/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.api.rest.client;

import com.vmware.vcloud.api.rest.client.VcdErrorException;
import com.vmware.vcloud.api.rest.schema_v1_5.ErrorType;
import javax.ws.rs.WebApplicationException;

public class VcdErrorResponseException
extends VcdErrorException {
    private static final long serialVersionUID = 1L;
    private final ErrorType vcdError;
    private final String requestId;
    private final String errorMsg;

    public VcdErrorResponseException(int httpStatusCode, String requestId, ErrorType vcdError, WebApplicationException cause) {
        super(httpStatusCode, cause);
        this.requestId = requestId;
        this.vcdError = vcdError;
        this.errorMsg = vcdError != null ? vcdError.getMessage() : null;
    }

    public VcdErrorResponseException(int httpStatusCode, String requestId, String vcdError, WebApplicationException cause) {
        super(httpStatusCode, cause);
        this.requestId = requestId;
        this.errorMsg = vcdError;
        this.vcdError = null;
    }

    public final ErrorType getVcdError() {
        return this.vcdError;
    }

    public final String getRequestId() {
        return this.requestId;
    }

    @Override
    public String toString() {
        return String.format("[VcdErrorResponseException] %s\nServer stack trace: %s", this.getMessage(), this.vcdError == null ? this.errorMsg : this.vcdError.getStackTrace());
    }

    @Override
    public String getMessage() {
        return String.format("HTTP status code = %d\nRequest ID: %s\nVCD Error: %s\nVCD ErrorType: major error code = %d, minor error code = %s", this.getHttpStatusCode(), this.requestId, this.vcdError == null ? this.errorMsg : this.vcdError.getMessage(), this.vcdError == null ? 0 : this.vcdError.getMajorErrorCode(), this.vcdError == null ? "-" : this.vcdError.getMinorErrorCode());
    }
}

