/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.api.rest.client;

import com.vmware.vcloud.api.rest.client.ClientCredentials;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.text.MessageFormat;
import java.util.zip.GZIPOutputStream;
import org.apache.cxf.common.util.Base64Utility;

public class VcdSignLoginCredentials
implements ClientCredentials {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final String TOKEN_SIGNATURE_ALGORITHM = "SHA256withRSA";
    private final String signAuthenticationHeader;

    public VcdSignLoginCredentials(String samlBearerTokenXml, String org) {
        String encodedToken = this.encodeToken(samlBearerTokenXml);
        this.signAuthenticationHeader = MessageFormat.format("SIGN token=\"{0}\",org=\"{1}\"", encodedToken, org);
    }

    public VcdSignLoginCredentials(String samlHokTokenXml, String org, PrivateKey privateKey) throws GeneralSecurityException {
        String encodedToken = this.encodeToken(samlHokTokenXml);
        String signature = this.signToken(samlHokTokenXml, privateKey);
        this.signAuthenticationHeader = MessageFormat.format("SIGN token=\"{0}\",org=\"{1}\",signature=\"{2}\",signature_alg=\"{3}\"", encodedToken, org, signature, TOKEN_SIGNATURE_ALGORITHM);
    }

    private String encodeToken(String samlTokenXml) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(baos);
            gzipOutputStream.write(samlTokenXml.getBytes(UTF8_CHARSET));
            gzipOutputStream.flush();
            gzipOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error zipping saml token!", e);
        }
        byte[] encodedTokenBytes = baos.toByteArray();
        String encodedToken = Base64Utility.encode((byte[])encodedTokenBytes);
        return encodedToken;
    }

    private String signToken(String samlTokenXml, PrivateKey privateKey) throws GeneralSecurityException {
        Signature signer = Signature.getInstance(TOKEN_SIGNATURE_ALGORITHM);
        signer.initSign(privateKey);
        signer.update(samlTokenXml.getBytes(UTF8_CHARSET));
        byte[] signatureBytes = signer.sign();
        String signature = Base64Utility.encode((byte[])signatureBytes);
        return signature;
    }

    @Override
    public String getHeaderValue() {
        return this.signAuthenticationHeader;
    }

    @Override
    public String getHeaderName() {
        return "Authorization";
    }

    @Override
    public boolean supportsSessionless() {
        return true;
    }
}

