/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.api.rest.client;

import com.vmware.vcloud.api.rest.schema_v1_5.ErrorType;
import com.vmware.vcloud.api.rest.schema_v1_5.ReferenceType;

public class VcdTaskException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final ReferenceType owner;
    private final ErrorType error;
    private final String errorMessage;

    public VcdTaskException(ReferenceType owner, String errorMessage, ErrorType error) {
        this.owner = owner;
        this.errorMessage = errorMessage;
        this.error = error;
    }

    public ReferenceType getOwner() {
        return this.owner;
    }

    public ErrorType getError() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String toString() {
        return String.format("[VcdTaskException] %s\nServer stack trace: %s", this.getMessage(), this.error == null ? null : this.error.getStackTrace());
    }

    @Override
    public String getMessage() {
        return String.format("VCD Error: %s\nVCD ErrorType: major error code = %d, minor error code = %s", this.error == null ? null : this.error.getMessage(), this.error == null ? 0 : this.error.getMajorErrorCode(), this.error == null ? "-" : this.error.getMinorErrorCode());
    }
}

