/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.api.rest.client;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;

@Produces(value={"application/xml", "application/*+xml", "text/xml"})
@Consumes(value={"application/xml", "application/*+xml", "text/xml"})
public class XStreamXmlProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final Set<Class> processed = new HashSet<Class>();
    private static final XStream xstream = new XStream();
    private static final String DEFAULT_ENCODING = "utf-8";

    public boolean isReadable(Class<?> classType, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return classType.getAnnotation(XStreamAlias.class) != null;
    }

    public Object readFrom(Class<Object> classType, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String encoding = XStreamXmlProvider.getCharsetAsString(mediaType);
        XStream xStream = this.getXStream(classType);
        return xStream.fromXML((Reader)new InputStreamReader(entityStream, encoding));
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.getAnnotation(XStreamAlias.class) != null;
    }

    public long getSize(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String encoding = XStreamXmlProvider.getCharsetAsString(mediaType);
        XStream xStream = this.getXStream(o.getClass());
        xStream.toXML(o, (Writer)new OutputStreamWriter(entityStream, encoding));
    }

    protected static String getCharsetAsString(MediaType mediaType) {
        if (mediaType == null) {
            return DEFAULT_ENCODING;
        }
        String result = (String)mediaType.getParameters().get("charset");
        return result == null ? DEFAULT_ENCODING : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XStream getXStream(Class type) {
        Set<Class> set = processed;
        synchronized (set) {
            if (!processed.contains(type)) {
                xstream.processAnnotations(type);
                processed.add(type);
            }
        }
        return xstream;
    }
}

