/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.api.rest.client.impl;

import com.vmware.vcloud.api.rest.client.EventViewer;
import com.vmware.vcloud.api.rest.client.VcdClient;
import com.vmware.vcloud.api.rest.schema_v1_5.QueryResultEventRecordType;
import java.util.ListIterator;
import java.util.Objects;

public class EventViewerImpl
implements EventViewer {
    private final VcdClient client;
    private static final String EVENT_QUERY_TYPE_NAME = "event";

    public EventViewerImpl(VcdClient client) {
        this.client = Objects.requireNonNull(client);
    }

    @Override
    public QueryResultEventRecordType getSingleEvent(String eventType, String entityHref) {
        ListIterator<VcdClient.QueryListPage<QueryResultEventRecordType>> it = this.client.getQuery(EVENT_QUERY_TYPE_NAME, QueryResultEventRecordType.class).setFilter("eventType==" + eventType + ";entity==" + entityHref).execute();
        if (!it.hasNext()) {
            throw new RuntimeException("Event '" + eventType + "' for entity '" + entityHref + "' not found.");
        }
        VcdClient.QueryListPage<QueryResultEventRecordType> events = it.next();
        long eventCount = events.getTotalItemCount();
        if (eventCount > 1L) {
            throw new RuntimeException("Found multiple (" + eventCount + ") events of type '" + eventType + "' for entity '" + entityHref + "' when expected only one.");
        }
        QueryResultEventRecordType event = events.getPage().get(0);
        return event;
    }

    @Override
    public QueryResultEventRecordType getLatestEvent(String eventType) {
        ListIterator<VcdClient.QueryListPage<QueryResultEventRecordType>> it = this.client.getQuery(EVENT_QUERY_TYPE_NAME, QueryResultEventRecordType.class).setFilter("eventType==" + eventType).setSortDesc("timeStamp").execute();
        if (!it.hasNext()) {
            throw new RuntimeException("Event '" + eventType + "' not found.");
        }
        VcdClient.QueryListPage<QueryResultEventRecordType> events = it.next();
        return events.getPage().get(0);
    }
}

