/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.example.quotes;

import com.webull.openapi.common.Region;
import com.webull.openapi.common.dict.Category;
import com.webull.openapi.common.dict.SubscribeType;
import com.webull.openapi.execption.ClientException;
import com.webull.openapi.execption.ServerException;
import com.webull.openapi.grpc.exception.UserCancelledException;
import com.webull.openapi.logger.Logger;
import com.webull.openapi.logger.LoggerFactory;
import com.webull.openapi.quotes.subsribe.QuotesSubsClient;
import com.webull.openapi.quotes.subsribe.message.MarketData;
import com.webull.openapi.serialize.JsonSerializer;
import io.reactivex.CompletableObserver;
import io.reactivex.Flowable;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;

public class QuotesSubscribe {
    private static final Logger logger = LoggerFactory.getLogger(QuotesSubscribe.class);

    public static void main(String[] args) {
        HashSet<String> symbols = new HashSet<String>();
        symbols.add("00700");
        HashSet<String> subTypes = new HashSet<String>();
        subTypes.add(SubscribeType.SNAPSHOT.name());
        try (QuotesSubsClient client = QuotesSubsClient.builder().appKey("<your_app_key>").appSecret("<your_app_secret>").regionId(Region.hk.name()).onMessage(QuotesSubscribe::handleMarketData).addSubscription(symbols, Category.HK_STOCK.name(), subTypes).build();){
            QuotesSubscribe.subscribeBlocking(client);
        }
        catch (ClientException ex) {
            logger.error("Client error", (Throwable)ex);
        }
        catch (ServerException ex) {
            logger.error("Sever error", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error("Unknown error", (Throwable)ex);
        }
    }

    private static void handleMarketData(MarketData marketData) {
        logger.info("Received market data: {}", (Object)JsonSerializer.toJson((Object)marketData));
    }

    private static void subscribeBlocking(QuotesSubsClient client) {
        client.connectBlocking();
        client.subscribeBlocking();
        logger.info("Subscribe completed.");
    }

    private static void subscribeAsync(QuotesSubsClient client) {
        CompletableFuture connectFuture = client.connectAsync();
        CompletionStage subscribeFuture = connectFuture.thenCompose(ack -> client.subscribeAsync());
        try {
            ((CompletableFuture)subscribeFuture).get();
            logger.info("Subscribe completed.");
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ClientException) {
                throw (ClientException)cause;
            }
            if (cause instanceof ServerException) {
                throw (ServerException)cause;
            }
            throw new ClientException("Unknown error", cause);
        }
    }

    private static void subscribeRx(QuotesSubsClient client) {
        Flowable subscribeFlow = client.connectRx().flatMapPublisher(ack -> client.subscribeRx());
        subscribeFlow.ignoreElements().subscribe(new CompletableObserver(){

            public void onSubscribe(@NonNull Disposable disposable) {
                logger.info("Start to subscribing.");
            }

            public void onComplete() {
                logger.info("Subscribe completed.");
            }

            public void onError(@NonNull Throwable ex) {
                if (!(ex instanceof UserCancelledException)) {
                    logger.error("Subscribe error", ex);
                }
            }
        });
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

