/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.example.quotes;

import com.google.api.client.util.Lists;
import com.webull.openapi.common.dict.Category;
import com.webull.openapi.common.dict.Timespan;
import com.webull.openapi.common.dict.TradingSession;
import com.webull.openapi.common.dict.YesOrNo;
import com.webull.openapi.example.config.Env;
import com.webull.openapi.execption.ClientException;
import com.webull.openapi.execption.ServerException;
import com.webull.openapi.logger.Logger;
import com.webull.openapi.logger.LoggerFactory;
import com.webull.openapi.quotes.api.QuotesApiClient;
import com.webull.openapi.quotes.domain.BatchBarResponse;
import com.webull.openapi.quotes.domain.Quote;
import com.webull.openapi.serialize.JsonSerializer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class QuotesGrpcApi {
    private static final Logger logger = LoggerFactory.getLogger(QuotesGrpcApi.class);

    public static void main(String[] args) {
        String symbol = "AAPL";
        try (QuotesApiClient quotesApiClient = QuotesApiClient.builder().appKey("<your_app_key>").appSecret("<your_app_secret>").regionId(Env.REGION_ID).build();){
            HashSet<String> symbols = new HashSet<String>();
            symbols.add("AAPL");
            symbols.add("TSLA");
            ArrayList<String> tradingSessions = new ArrayList<String>();
            tradingSessions.add(TradingSession.PRE.name());
            tradingSessions.add(TradingSession.RTH.name());
            tradingSessions.add(TradingSession.ATH.name());
            tradingSessions.add(TradingSession.OVN.name());
            List instruments = quotesApiClient.getInstruments(symbols, Category.US_STOCK.name());
            logger.info("Instruments: {}", (Object)JsonSerializer.toJson((Object)instruments));
            List bars = quotesApiClient.getBars(symbol, Category.US_STOCK.name(), Timespan.D.name(), 10);
            logger.info("Bars: {}", (Object)JsonSerializer.toJson((Object)bars));
            BatchBarResponse batchBars = quotesApiClient.getBatchBars((List)Lists.newArrayList(symbols), Category.US_STOCK.name(), Timespan.M1.name(), 2);
            logger.info("Batch bars: {}", (Object)JsonSerializer.toJson((Object)batchBars));
            bars = quotesApiClient.getBars(symbol, Category.US_STOCK.name(), Timespan.M5.name(), 10, YesOrNo.N.name(), tradingSessions);
            logger.info("Bars: {}", (Object)JsonSerializer.toJson((Object)bars));
            batchBars = quotesApiClient.getBatchBars((List)Lists.newArrayList(symbols), Category.US_STOCK.name(), Timespan.M15.name(), 2, YesOrNo.N.name(), tradingSessions);
            logger.info("Batch bars: {}", (Object)JsonSerializer.toJson((Object)batchBars));
            Quote quote = quotesApiClient.getQuote(symbol, Category.US_STOCK.name());
            logger.info("Quote: {}", (Object)JsonSerializer.toJson((Object)quote));
            List snapshots = quotesApiClient.getSnapshots(symbols, Category.US_STOCK.name());
            logger.info("Snapshots: {}", (Object)JsonSerializer.toJson((Object)snapshots));
            List ticks = quotesApiClient.getTicks(symbol, Category.US_STOCK.name(), 10);
            logger.info("Ticks: {}", (Object)JsonSerializer.toJson((Object)ticks));
        }
        catch (ClientException ex) {
            logger.error("Client error", (Throwable)ex);
        }
        catch (ServerException ex) {
            logger.error("Sever error", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error("Unknown error", (Throwable)ex);
        }
    }
}

