/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.grpc;

import com.webull.openapi.grpc.GrpcClient;
import com.webull.openapi.grpc.lifecycle.GrpcHandler;
import com.webull.openapi.grpc.lifecycle.SubStreamObserver;
import com.webull.openapi.grpc.lifecycle.proxy.HandlerProxyFactory;
import com.webull.openapi.retry.RetryPolicy;
import com.webull.openapi.utils.Assert;
import com.webull.openapi.utils.CollectionUtils;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.Closeable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class BaseGrpcClient<RespT>
implements GrpcClient,
Closeable {
    protected final String appKey;
    protected final String appSecret;
    protected final String host;
    protected final int port;
    protected final RetryPolicy retryPolicy;
    protected final boolean enableTls;
    protected final LinkedList<SubStreamObserver<RespT>> subObservers;
    protected ManagedChannel channel;

    protected BaseGrpcClient(String appKey, String appSecret, String host, int port, RetryPolicy retryPolicy, boolean enableTls) {
        this(appKey, appSecret, host, port, retryPolicy, enableTls, null, null);
    }

    protected BaseGrpcClient(String appKey, String appSecret, String host, int port, RetryPolicy retryPolicy, boolean enableTls, List<GrpcHandler> handlers, HandlerProxyFactory<RespT> handlerProxyFactory) {
        Assert.notBlank((String)"appKey", (String)appKey);
        Assert.notBlank((String)"appSecret", (String)appSecret);
        Assert.notBlank((String)"host", (String)host);
        Assert.inRange((String)"port", (int)port, (int)0, (int)65535);
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.host = host;
        this.port = port;
        this.retryPolicy = retryPolicy != null ? retryPolicy : RetryPolicy.never();
        this.enableTls = enableTls;
        this.subObservers = CollectionUtils.isNotEmpty(handlers) ? new LinkedList<SubStreamObserver<RespT>>(handlerProxyFactory.create(handlers)) : new LinkedList();
    }

    protected void buildChannel() {
        ManagedChannelBuilder channelBuilder = ManagedChannelBuilder.forAddress((String)this.host, (int)this.port);
        if (this.enableTls) {
            channelBuilder.useTransportSecurity();
        } else {
            channelBuilder.usePlaintext();
        }
        this.channel = channelBuilder.build();
    }

    @Override
    public void shutdown(long timeout, TimeUnit timeUnit) throws InterruptedException {
        boolean success;
        if (this.channel != null && !this.channel.isShutdown() && !(success = this.channel.shutdown().awaitTermination(timeout, timeUnit))) {
            this.channel.shutdownNow();
        }
    }

    @Override
    public void shutdownNow() {
        if (this.channel != null && !this.channel.isShutdown()) {
            this.channel.shutdownNow();
        }
    }

    @Override
    public void close() {
        try {
            this.shutdown(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

