/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.grpc.auth;

import com.webull.openapi.auth.composer.DefaultSignatureComposer;
import com.webull.openapi.auth.signer.SignAlgorithm;
import com.webull.openapi.auth.signer.Signer;
import com.webull.openapi.auth.signer.SignerFactory;
import com.webull.openapi.utils.DateUtils;
import com.webull.openapi.utils.GUID;
import com.webull.openapi.utils.MD5Utils;
import com.webull.openapi.utils.StringUtils;
import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.HashMap;
import java.util.concurrent.Executor;

public class SignatureCallCredentials
extends CallCredentials {
    private static final Metadata.Key<String> APP_KEY = Metadata.Key.of((String)"x-app-key", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> SIGN_ALGORITHM = Metadata.Key.of((String)"x-signature-algorithm", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> SIGN_VERSION = Metadata.Key.of((String)"x-signature-version", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> NONCE = Metadata.Key.of((String)"x-signature-nonce", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> TIMESTAMP = Metadata.Key.of((String)"x-timestamp", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> SIGNATURE = Metadata.Key.of((String)"x-signature", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final String appKey;
    private final String appSecret;
    private final String host;
    private final Integer port;
    private final String url;
    private final Signer signer;
    private final byte[] requestBytes;

    public SignatureCallCredentials(String appKey, String appSecret, byte[] requestBytes) {
        this(appKey, appSecret, null, null, null, requestBytes);
    }

    public SignatureCallCredentials(String appKey, String appSecret, String host, Integer port, String url, byte[] requestBytes) {
        this(appKey, appSecret, host, port, url, requestBytes, SignerFactory.getInstance().get(SignAlgorithm.HMAC_SHA1));
    }

    public SignatureCallCredentials(String appKey, String appSecret, String host, Integer port, String url, byte[] requestBytes, Signer signer) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.host = host;
        this.port = port;
        this.url = url;
        this.requestBytes = requestBytes;
        this.signer = signer;
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor executor, CallCredentials.MetadataApplier applier) {
        executor.execute(() -> {
            try {
                String signAlgorithm = this.signer.signerName();
                String signVersion = this.signer.signerVersion();
                String guid = GUID.get();
                String timestamp = DateUtils.getTimestamp();
                Metadata headers = new Metadata();
                headers.put(APP_KEY, (Object)this.appKey);
                headers.put(SIGN_ALGORITHM, (Object)signAlgorithm);
                headers.put(SIGN_VERSION, (Object)signVersion);
                headers.put(NONCE, (Object)guid);
                headers.put(TIMESTAMP, (Object)timestamp);
                HashMap<String, String> signParams = new HashMap<String, String>();
                if (StringUtils.isNotEmpty((CharSequence)this.host) && this.port != null) {
                    signParams.put("Host".toLowerCase(), this.host + ":" + this.port);
                }
                signParams.put("x-app-key", this.appKey);
                signParams.put("x-signature-algorithm", signAlgorithm);
                signParams.put("x-signature-version", signVersion);
                signParams.put("x-signature-nonce", guid);
                signParams.put("x-timestamp", timestamp);
                String payload = this.requestBytes != null ? MD5Utils.md5((byte[])this.requestBytes) : null;
                String sign = DefaultSignatureComposer.getSign(signParams, (String)this.url, (String)payload, (String)this.appSecret, (Signer)this.signer);
                headers.put(SIGNATURE, (Object)sign);
                applier.apply(headers);
            }
            catch (Exception e) {
                applier.fail(Status.UNAUTHENTICATED.withCause((Throwable)e));
            }
        });
    }

    public void thisUsesUnstableApi() {
    }
}

