/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.grpc.lifecycle;

import com.webull.openapi.grpc.lifecycle.SubStreamObserver;
import com.webull.openapi.utils.Assert;
import java.util.List;

public abstract class ComposeSubStreamObserver<I, O>
implements SubStreamObserver<I> {
    private final List<SubStreamObserver<O>> subObservers;

    protected ComposeSubStreamObserver(List<SubStreamObserver<O>> observers) {
        Assert.notNull((String)"observers", observers);
        this.subObservers = observers;
    }

    @Override
    public void onReady() {
        this.subObservers.forEach(SubStreamObserver::onReady);
    }

    @Override
    public void onNext(I value) {
        if (!this.subObservers.isEmpty()) {
            Object decoded = this.decodeForSubs(value);
            this.subObservers.forEach(observer -> observer.onNext(decoded));
        }
    }

    @Override
    public void onError(Throwable cause) {
        this.subObservers.forEach(observer -> observer.onError(cause));
    }

    @Override
    public void onCompleted() {
        this.subObservers.forEach(SubStreamObserver::onCompleted);
    }

    protected abstract O decodeForSubs(I var1);
}

