/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.grpc.retry;

import com.webull.openapi.grpc.lifecycle.GrpcFailedContext;
import com.webull.openapi.retry.RetryContext;
import com.webull.openapi.retry.condition.RetryCondition;
import io.grpc.Status;

public class GrpcRetryCondition
implements RetryCondition {
    private GrpcRetryCondition() {
    }

    public static GrpcRetryCondition getInstance() {
        return InstanceHolder.instance;
    }

    public boolean shouldRetry(RetryContext context) {
        if (!(context instanceof GrpcFailedContext)) {
            throw new IllegalArgumentException("Retry context[" + context.getClass().getName() + "] is inappropriate to grpc retry condition!");
        }
        GrpcFailedContext grpcFailedContext = (GrpcFailedContext)context;
        if (grpcFailedContext.userCancelled()) {
            return false;
        }
        int statusCode = grpcFailedContext.getStatusCode();
        return Status.UNKNOWN.getCode().value() == statusCode || Status.INTERNAL.getCode().value() == statusCode || Status.UNAVAILABLE.getCode().value() == statusCode;
    }

    private static class InstanceHolder {
        private static final GrpcRetryCondition instance = new GrpcRetryCondition();

        private InstanceHolder() {
        }
    }
}

