/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.quotes.internal.grpc;

import com.webull.openapi.common.ApiModule;
import com.webull.openapi.endpoint.EndpointResolver;
import com.webull.openapi.execption.ClientException;
import com.webull.openapi.grpc.lifecycle.GrpcHandler;
import com.webull.openapi.grpc.retry.GrpcRetryCondition;
import com.webull.openapi.quotes.api.QuotesApiClient;
import com.webull.openapi.quotes.api.QuotesApiClientBuilder;
import com.webull.openapi.quotes.api.lifecycle.ApiDowngradeHandler;
import com.webull.openapi.quotes.internal.grpc.GrpcQuotesApiClient;
import com.webull.openapi.quotes.internal.grpc.lifecycle.ApiDowngradeLoggingHandler;
import com.webull.openapi.retry.RetryPolicy;
import com.webull.openapi.retry.backoff.BackoffStrategy;
import com.webull.openapi.retry.backoff.FixedDelayStrategy;
import com.webull.openapi.retry.condition.RetryCondition;
import com.webull.openapi.utils.Assert;
import com.webull.openapi.utils.StringUtils;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;

public class GrpcQuotesApiClientBuilder
implements QuotesApiClientBuilder {
    private String appKey;
    private String appSecret;
    private String regionId;
    private String host;
    private int port = 443;
    private long connectTimeoutMillis = 10000L;
    private long readTimeoutMillis = 10000L;
    private RetryPolicy retryPolicy = new RetryPolicy((RetryCondition)GrpcRetryCondition.getInstance(), (BackoffStrategy)new FixedDelayStrategy(5L, TimeUnit.SECONDS));
    private boolean enableTls = true;
    private final LinkedList<GrpcHandler> handlers = new LinkedList();

    @Override
    public QuotesApiClientBuilder appKey(String appKey) {
        this.appKey = appKey;
        return this;
    }

    @Override
    public QuotesApiClientBuilder appSecret(String appSecret) {
        this.appSecret = appSecret;
        return this;
    }

    @Override
    public QuotesApiClientBuilder host(String host) {
        this.host = host;
        return this;
    }

    @Override
    public QuotesApiClientBuilder port(int port) {
        this.port = port;
        return this;
    }

    @Override
    public QuotesApiClientBuilder regionId(String regionId) {
        this.regionId = regionId;
        return this;
    }

    @Override
    public QuotesApiClientBuilder connectTimeout(long timeoutMillis) {
        this.connectTimeoutMillis = timeoutMillis;
        return this;
    }

    @Override
    public QuotesApiClientBuilder readTimeout(long timeoutMillis) {
        this.readTimeoutMillis = timeoutMillis;
        return this;
    }

    @Override
    public QuotesApiClientBuilder enableTls(boolean enableTls) {
        this.enableTls = enableTls;
        return this;
    }

    @Override
    public QuotesApiClientBuilder reconnectBy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    @Override
    public QuotesApiClientBuilder addHandler(GrpcHandler handler) {
        Assert.notNull((String)"handler", (Object)handler);
        this.handlers.add(handler);
        return this;
    }

    @Override
    public QuotesApiClient build() {
        if (StringUtils.isBlank((CharSequence)this.host)) {
            Assert.notBlank((String)"regionId", (String)this.regionId);
            this.host = (String)EndpointResolver.getDefault().resolve(this.regionId, ApiModule.QUOTES).orElseThrow(() -> new ClientException("EndpointResolvingError", "Unknown region"));
        }
        if (this.handlers.stream().noneMatch(ApiDowngradeHandler.class::isInstance)) {
            this.handlers.add(new ApiDowngradeLoggingHandler());
        }
        return new GrpcQuotesApiClient(this.appKey, this.appSecret, this.host, this.port, this.connectTimeoutMillis, this.readTimeoutMillis, this.retryPolicy, this.enableTls, this.handlers);
    }
}

