/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.quotes.internal.grpc.lifecycle;

import com.webull.openapi.grpc.lifecycle.SubStreamObserver;
import com.webull.openapi.logger.Logger;
import com.webull.openapi.logger.LoggerFactory;
import com.webull.openapi.quotes.internal.grpc.proto.Gateway;

public final class ApiLoggingHandler
implements SubStreamObserver<Gateway.ClientResponse> {
    private static final Logger logger = LoggerFactory.getLogger(ApiLoggingHandler.class);
    private static final ApiLoggingHandler instance = new ApiLoggingHandler();

    private ApiLoggingHandler() {
    }

    public static ApiLoggingHandler getInstance() {
        return instance;
    }

    public void onReady() {
        if (logger.isDebugEnabled()) {
            logger.debug("Quotes grpc session on ready.");
        }
    }

    public void onNext(Gateway.ClientResponse value) {
        if (logger.isDebugEnabled()) {
            logger.debug("Received quotes grpc msg[{}]={}", new Object[]{value.getType().name(), value});
        }
    }

    public void onError(Throwable cause) {
        logger.error("Quotes grpc session on error.", cause);
    }

    public void onCompleted() {
        if (logger.isDebugEnabled()) {
            logger.debug("Quotes grpc session on completed.");
        }
    }
}

