/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.quotes.internal.grpc.lifecycle;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.webull.openapi.logger.Logger;
import com.webull.openapi.logger.LoggerFactory;
import com.webull.openapi.utils.GUID;
import java.io.Closeable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class IdleStateHandler
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(IdleStateHandler.class);
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final ThreadFactory idleThreadFactory = new ThreadFactoryBuilder().setNameFormat("quotesIdleStateHandler-%d").setDaemon(true).build();
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(idleThreadFactory);
    private volatile ScheduledFuture<?> scheduledFuture;
    private final AtomicReference<IdleTask> taskRef = new AtomicReference();
    private final AtomicLong lastWriteTime = new AtomicLong(0L);
    private final long idleTimeNanos;
    private final Runnable doHeartbeat;

    public IdleStateHandler(long idleTime, TimeUnit timeUnit, Runnable doHeartbeat) {
        this.idleTimeNanos = Math.max(timeUnit.toNanos(idleTime), MIN_TIMEOUT_NANOS);
        this.doHeartbeat = doHeartbeat;
    }

    public void start() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        IdleTask task = new IdleTask();
        this.taskRef.set(task);
        if (logger.isDebugEnabled()) {
            logger.debug("Start grpc idle task[{}].", (Object)task.taskId);
        }
        this.scheduledFuture = executor.schedule(task, this.idleTimeNanos, TimeUnit.NANOSECONDS);
    }

    public void onSend() {
        long prev;
        long now = System.nanoTime();
        if (now > (prev = this.lastWriteTime.get())) {
            this.lastWriteTime.compareAndSet(prev, now);
        }
    }

    @Override
    public synchronized void close() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
        IdleTask task = this.taskRef.getAndSet(null);
        if (logger.isDebugEnabled() && task != null) {
            logger.debug("Stop grpc idle task[{}] on grpc closed.", (Object)task.taskId);
        }
    }

    private final class IdleTask
    implements Runnable {
        private final String taskId = GUID.get();

        private IdleTask() {
        }

        @Override
        public void run() {
            if (this != IdleStateHandler.this.taskRef.get()) {
                return;
            }
            long nextDelay = IdleStateHandler.this.lastWriteTime.get() + IdleStateHandler.this.idleTimeNanos - System.nanoTime();
            if (nextDelay <= 0L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Grpc idle task[{}] send heartbeat...", (Object)this.taskId);
                }
                try {
                    IdleStateHandler.this.doHeartbeat.run();
                    IdleStateHandler.this.onSend();
                }
                catch (Exception e) {
                    logger.error("Grpc idle task[{}] error", new Object[]{this.taskId, e});
                }
                IdleStateHandler.this.scheduledFuture = executor.schedule(this, IdleStateHandler.this.idleTimeNanos, TimeUnit.NANOSECONDS);
            } else {
                IdleStateHandler.this.scheduledFuture = executor.schedule(this, nextDelay, TimeUnit.NANOSECONDS);
            }
        }
    }
}

