/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.quotes.internal.grpc.lifecycle;

import com.webull.openapi.execption.ClientException;
import com.webull.openapi.quotes.api.lifecycle.ReplyMessage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;

public class SimpleReplyMessage<RespT>
implements ReplyMessage<RespT> {
    private final CompletableFuture<RespT> future = new CompletableFuture();

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public RespT get() {
        try {
            return this.future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ClientException("InvalidState", "Request interrupted.", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new ClientException("Request error.", (Throwable)e);
        }
    }

    @Override
    public RespT get(long timeout, TimeUnit timeUnit) {
        try {
            return this.future.get(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ClientException("InvalidState", "Request interrupted.", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new ClientException("Request error.", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new ClientException("Timeout", "Read timeout.", (Throwable)e);
        }
    }

    @Override
    public boolean receive(RespT receive) {
        return this.future.complete(receive);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        return this.future.completeExceptionally(ex);
    }

    public SimpleReplyMessage<RespT> whenComplete(BiConsumer<? super RespT, ? super Throwable> completeAction) {
        this.future.whenComplete(completeAction);
        return this;
    }

    @Override
    public void close() {
        if (!this.future.isDone()) {
            this.future.cancel(false);
        }
    }
}

