/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.quotes.internal.grpc.lifecycle.channel;

import com.webull.openapi.quotes.internal.grpc.lifecycle.channel.ChannelPool;
import com.webull.openapi.quotes.internal.grpc.lifecycle.channel.ChannelPoolMap;
import com.webull.openapi.utils.Assert;
import java.io.Closeable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractChannelPoolMap<E, P extends ChannelPool<?, ?>>
implements ChannelPoolMap<E, P>,
Closeable {
    private final ConcurrentMap<E, P> map = new ConcurrentHashMap<E, P>();

    @Override
    public P get(E endpoint) {
        ChannelPool old;
        Assert.notNull((String)"endpoint", endpoint);
        ChannelPool pool = (ChannelPool)this.map.get(endpoint);
        if (pool == null && (old = this.map.putIfAbsent(endpoint, pool = this.newPool(endpoint))) != null) {
            pool.close();
            pool = old;
        }
        return (P)pool;
    }

    protected abstract P newPool(E var1);

    @Override
    public void close() {
        for (ChannelPool pool : this.map.values()) {
            pool.close();
        }
        this.map.clear();
    }
}

