/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.quotes.internal.grpc.lifecycle.channel;

import com.webull.openapi.execption.ClientException;
import com.webull.openapi.quotes.api.lifecycle.Mailbox;
import com.webull.openapi.quotes.api.lifecycle.ReplyMessage;
import com.webull.openapi.quotes.internal.grpc.lifecycle.SimpleReplyMessage;
import com.webull.openapi.quotes.internal.grpc.proto.Gateway;
import com.webull.openapi.utils.Assert;
import com.webull.openapi.utils.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;

public class InFlightRequestsBox
implements Mailbox<Gateway.ClientRequest, Gateway.ClientResponse>,
Closeable {
    private final int maxInflightSize;
    private final ConcurrentHashMap<String, SimpleReplyMessage<Gateway.ClientResponse>> results;

    public InFlightRequestsBox(int maxInflightSize) {
        this.maxInflightSize = maxInflightSize;
        this.results = new ConcurrentHashMap(32);
    }

    @Override
    public void send(Gateway.ClientRequest value) {
    }

    @Override
    public ReplyMessage<Gateway.ClientResponse> exchange(Gateway.ClientRequest request) {
        Assert.notBlank((String)"requestId", (String)request.getRequestId());
        if (this.results.size() >= this.maxInflightSize) {
            throw new ClientException("TooManyRequests", "To many in flight requests, exceeded max=" + this.maxInflightSize);
        }
        return this.results.computeIfAbsent(request.getRequestId(), requestId -> {
            SimpleReplyMessage<Gateway.ClientResponse> replyMessage = new SimpleReplyMessage<Gateway.ClientResponse>();
            replyMessage.whenComplete((response, error) -> this.results.remove(requestId).close());
            return replyMessage;
        });
    }

    @Override
    public void receive(Gateway.ClientResponse response) {
        if (StringUtils.isEmpty((CharSequence)response.getRequestId())) {
            return;
        }
        ReplyMessage replyMessage = this.results.get(response.getRequestId());
        if (replyMessage != null) {
            replyMessage.receive(response);
        }
    }

    @Override
    public void close() {
        this.results.values().forEach(replyMessage -> replyMessage.completeExceptionally(new IOException("Grpc channel closed.")));
    }
}

