/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.quotes.internal.grpc.lifecycle.proxy;

import com.webull.openapi.grpc.lifecycle.GrpcHandler;
import com.webull.openapi.grpc.lifecycle.SubStreamObserver;
import com.webull.openapi.grpc.lifecycle.proxy.DefaultHandlerProxyFactory;
import com.webull.openapi.logger.Logger;
import com.webull.openapi.logger.LoggerFactory;
import com.webull.openapi.quotes.api.lifecycle.ApiDowngradeHandler;
import com.webull.openapi.quotes.api.lifecycle.ApiInboundHandler;
import com.webull.openapi.quotes.internal.grpc.lifecycle.proxy.ApiDowngradeHandlerProxy;
import com.webull.openapi.quotes.internal.grpc.lifecycle.proxy.ApiInboundHandlerProxy;
import com.webull.openapi.quotes.internal.grpc.proto.Gateway;
import java.util.List;

public class ApiHandlerProxyFactory
extends DefaultHandlerProxyFactory<Gateway.ClientResponse> {
    private static final Logger logger = LoggerFactory.getLogger(ApiHandlerProxyFactory.class);

    private ApiHandlerProxyFactory() {
    }

    public static ApiHandlerProxyFactory getInstance() {
        return InstanceHolder.instance;
    }

    public List<SubStreamObserver<Gateway.ClientResponse>> create(GrpcHandler handler) {
        List result = super.create(handler);
        if (handler instanceof ApiInboundHandler) {
            result.add(new ApiInboundHandlerProxy((ApiInboundHandler)handler));
        }
        if (handler instanceof ApiDowngradeHandler) {
            result.add(new ApiDowngradeHandlerProxy((ApiDowngradeHandler)handler));
        }
        if (result.isEmpty()) {
            logger.warn("Incapable of creating proxy for handler type={}.", handler.getClass());
        }
        return result;
    }

    private static class InstanceHolder {
        private static final ApiHandlerProxyFactory instance = new ApiHandlerProxyFactory();

        private InstanceHolder() {
        }
    }
}

