/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.quotes.internal.http;

import com.google.common.reflect.TypeToken;
import com.webull.openapi.http.HttpApiClient;
import com.webull.openapi.http.HttpApiConfig;
import com.webull.openapi.http.HttpRequest;
import com.webull.openapi.http.common.HttpMethod;
import com.webull.openapi.quotes.api.QuotesApiClient;
import com.webull.openapi.quotes.domain.Bar;
import com.webull.openapi.quotes.domain.Instrument;
import com.webull.openapi.quotes.domain.Quote;
import com.webull.openapi.quotes.domain.Snapshot;
import com.webull.openapi.quotes.domain.Tick;
import com.webull.openapi.utils.Assert;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class HttpQuotesApiClient
implements QuotesApiClient {
    private static final String NOT_SUPPORT_MSG = "Http client not support for this method, please use default grpc client.";
    private final HttpApiClient apiClient;

    public HttpQuotesApiClient(HttpApiConfig config) {
        this.apiClient = new HttpApiClient(config);
    }

    public HttpQuotesApiClient(HttpApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public List<Instrument> getInstruments(Set<String> symbols, String category) {
        Assert.notEmpty((String)"symbols", symbols);
        Assert.notBlank((String)"category", (String)category);
        HttpRequest request = new HttpRequest("/instrument/list", "v1", HttpMethod.GET);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("symbols", String.join((CharSequence)",", symbols));
        params.put("category", category);
        request.setQuery(params);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<Instrument>>(){}.getType()).doAction();
    }

    @Override
    public List<Bar> getBars(String symbol, String category, String timespan, int count) {
        Assert.notBlank(Arrays.asList("symbol", "category", "timespan"), (String[])new String[]{symbol, category, timespan});
        HttpRequest request = new HttpRequest("/market-data/bars", "v1", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("symbol", symbol);
        params.put("category", category);
        params.put("timespan", timespan);
        params.put("count", count);
        request.setQuery(params);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<Bar>>(){}.getType()).doAction();
    }

    @Override
    public Quote getQuote(String symbol, String category) {
        throw new UnsupportedOperationException(NOT_SUPPORT_MSG);
    }

    @Override
    public List<Snapshot> getSnapshots(Set<String> symbols, String category) {
        Assert.notEmpty((String)"symbols", symbols);
        Assert.notBlank((String)"category", (String)category);
        HttpRequest request = new HttpRequest("/market-data/snapshot", "v1", HttpMethod.GET);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("symbols", String.join((CharSequence)",", symbols));
        params.put("category", category);
        request.setQuery(params);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<Snapshot>>(){}.getType()).doAction();
    }

    @Override
    public List<Tick> getTicks(String symbol, String category, int count) {
        throw new UnsupportedOperationException(NOT_SUPPORT_MSG);
    }

    @Override
    public String getToken() {
        throw new UnsupportedOperationException(NOT_SUPPORT_MSG);
    }

    @Override
    public void subscribe(String token, Set<String> symbols, String category, Set<String> subTypes) {
        throw new UnsupportedOperationException(NOT_SUPPORT_MSG);
    }

    @Override
    public void unsubscribe(String token, Set<String> symbols, String category, Set<String> subTypes, Boolean unsubscribeAll) {
        throw new UnsupportedOperationException(NOT_SUPPORT_MSG);
    }
}

