/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.quotes.internal.mqtt;

import com.webull.openapi.common.ApiModule;
import com.webull.openapi.endpoint.EndpointResolver;
import com.webull.openapi.execption.ClientException;
import com.webull.openapi.quotes.api.QuotesApiClient;
import com.webull.openapi.quotes.internal.mqtt.DefaultQuotesSubsClient;
import com.webull.openapi.quotes.internal.mqtt.codec.PublishToMarketDataDecoder;
import com.webull.openapi.quotes.internal.mqtt.lifecycle.ApiAuthProvider;
import com.webull.openapi.quotes.internal.mqtt.lifecycle.ApiSubscriptionManager;
import com.webull.openapi.quotes.internal.mqtt.lifecycle.QuotesSubsLoggingHandler;
import com.webull.openapi.quotes.internal.mqtt.lifecycle.QuotesSubsReconnectHandler;
import com.webull.openapi.quotes.subsribe.QuotesSubsClient;
import com.webull.openapi.quotes.subsribe.QuotesSubsClientBuilder;
import com.webull.openapi.quotes.subsribe.lifecycle.QuotesSubsHandler;
import com.webull.openapi.quotes.subsribe.lifecycle.QuotesSubsInboundHandler;
import com.webull.openapi.quotes.subsribe.message.MarketData;
import com.webull.openapi.quotes.subsribe.proxy.ProxyConfig;
import com.webull.openapi.quotes.subsribe.retry.QuotesSubsRetryCondition;
import com.webull.openapi.retry.RetryPolicy;
import com.webull.openapi.retry.backoff.BackoffStrategy;
import com.webull.openapi.retry.backoff.FixedDelayStrategy;
import com.webull.openapi.retry.condition.RetryCondition;
import com.webull.openapi.utils.Assert;
import com.webull.openapi.utils.CollectionUtils;
import com.webull.openapi.utils.StringUtils;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public final class DefaultQuotesSubsClientBuilder
implements QuotesSubsClientBuilder {
    private String appKey;
    private String appSecret;
    private String regionId;
    private String host;
    private int port = 8883;
    private long connectTimeoutMillis = 5000L;
    private long readTimeoutMillis = 60000L;
    private QuotesApiClient quotesApiClient;
    private RetryPolicy retryPolicy = new RetryPolicy((RetryCondition)QuotesSubsRetryCondition.getInstance(), (BackoffStrategy)new FixedDelayStrategy(10L, TimeUnit.SECONDS));
    private boolean enableTls = true;
    private ProxyConfig proxyConfig;
    private final LinkedList<QuotesSubsHandler> handlers = new LinkedList();
    private final LinkedList<QuotesSubsInboundHandler> onMessages = new LinkedList();
    private Set<String> symbols;
    private String category;
    private Set<String> subTypes;

    @Override
    public QuotesSubsClientBuilder appKey(String appKey) {
        this.appKey = appKey;
        return this;
    }

    @Override
    public QuotesSubsClientBuilder appSecret(String appSecret) {
        this.appSecret = appSecret;
        return this;
    }

    @Override
    public QuotesSubsClientBuilder host(String host) {
        this.host = host;
        return this;
    }

    @Override
    public QuotesSubsClientBuilder port(int port) {
        this.port = port;
        return this;
    }

    @Override
    public QuotesSubsClientBuilder regionId(String regionId) {
        this.regionId = regionId;
        return this;
    }

    @Override
    public QuotesSubsClientBuilder connectTimeout(long timeoutMillis) {
        this.connectTimeoutMillis = timeoutMillis;
        return this;
    }

    @Override
    public QuotesSubsClientBuilder readTimeout(long timeoutMillis) {
        this.readTimeoutMillis = timeoutMillis;
        return this;
    }

    @Override
    public QuotesSubsClientBuilder apiClient(QuotesApiClient quotesApiClient) {
        this.quotesApiClient = quotesApiClient;
        return this;
    }

    @Override
    public QuotesSubsClientBuilder reconnectBy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    @Override
    public QuotesSubsClientBuilder enableTls(boolean enableTls) {
        this.enableTls = enableTls;
        return this;
    }

    @Override
    public QuotesSubsClientBuilder proxy(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
        return this;
    }

    @Override
    public QuotesSubsClientBuilder addHandler(QuotesSubsHandler handler) {
        Assert.notNull((String)"handler", (Object)handler);
        this.handlers.add(handler);
        return this;
    }

    @Override
    public QuotesSubsClientBuilder onMessage(Consumer<MarketData> consumer) {
        Assert.notNull((String)"consumer", consumer);
        QuotesSubsInboundHandler handler = message -> {
            consumer.accept((MarketData)message);
            return message;
        };
        this.onMessages.add(handler);
        return this;
    }

    @Override
    public QuotesSubsClientBuilder addSubscription(Set<String> symbols, String category, Set<String> subTypes) {
        this.symbols = symbols;
        this.category = category;
        this.subTypes = subTypes;
        return this;
    }

    @Override
    public QuotesSubsClient build() {
        if (StringUtils.isBlank((CharSequence)this.host)) {
            Assert.notBlank((String)"regionId", (String)this.regionId);
            this.host = (String)EndpointResolver.getDefault().resolve(this.regionId, ApiModule.QUOTES).orElseThrow(() -> new ClientException("EndpointResolvingError", "Unknown region"));
        }
        if (this.quotesApiClient == null) {
            this.quotesApiClient = QuotesApiClient.builder().appKey(this.appKey).appSecret(this.appSecret).host(this.host).build();
        }
        LinkedList<QuotesSubsHandler> allHandlers = new LinkedList<QuotesSubsHandler>();
        ApiAuthProvider authProvider = new ApiAuthProvider(this.appKey, this.quotesApiClient);
        allHandlers.add(new QuotesSubsLoggingHandler());
        if (this.retryPolicy != null) {
            QuotesSubsReconnectHandler reconnectHandler = new QuotesSubsReconnectHandler(this.appKey, authProvider, this.retryPolicy);
            allHandlers.add(reconnectHandler);
        }
        ApiSubscriptionManager subscriptionManager = CollectionUtils.isNotEmpty(this.symbols) || StringUtils.isNotBlank((CharSequence)this.category) || CollectionUtils.isNotEmpty(this.subTypes) ? new ApiSubscriptionManager(this.quotesApiClient, this.retryPolicy, this.symbols, this.category, this.subTypes) : new ApiSubscriptionManager(this.quotesApiClient, this.retryPolicy);
        allHandlers.add(subscriptionManager);
        allHandlers.add(new PublishToMarketDataDecoder());
        allHandlers.addAll(this.onMessages);
        allHandlers.addAll(this.handlers);
        return new DefaultQuotesSubsClient(this.host, this.port, this.enableTls, this.retryPolicy, authProvider, subscriptionManager, allHandlers, this.connectTimeoutMillis, this.readTimeoutMillis, this.proxyConfig);
    }
}

