/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.quotes.internal.mqtt.codec;

import com.webull.openapi.common.dict.SubscribeType;
import com.webull.openapi.logger.Logger;
import com.webull.openapi.logger.LoggerFactory;
import com.webull.openapi.quotes.domain.QuotesBasic;
import com.webull.openapi.quotes.internal.mqtt.codec.QuoteDecoder;
import com.webull.openapi.quotes.internal.mqtt.codec.QuotesPublishDecoder;
import com.webull.openapi.quotes.internal.mqtt.codec.SnapshotDecoder;
import com.webull.openapi.quotes.internal.mqtt.codec.TickDecoder;
import com.webull.openapi.quotes.internal.mqtt.message.MqttPublish;
import com.webull.openapi.quotes.subsribe.codec.AbstractInboundDecoder;
import com.webull.openapi.quotes.subsribe.message.MarketData;
import com.webull.openapi.quotes.subsribe.message.Metadata;
import com.webull.openapi.quotes.subsribe.message.QuotesPublish;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;

public class PublishToMarketDataDecoder
extends AbstractInboundDecoder<MqttPublish, MarketData> {
    private static final Logger logger = LoggerFactory.getLogger(PublishToMarketDataDecoder.class);
    private static final String SPLITER = "-";
    private final Map<SubscribeType, QuotesPublishDecoder<? extends QuotesBasic>> delegates = new EnumMap<SubscribeType, QuotesPublishDecoder<? extends QuotesBasic>>(SubscribeType.class);

    public PublishToMarketDataDecoder() {
        this.delegates.put(SubscribeType.QUOTE, new QuoteDecoder());
        this.delegates.put(SubscribeType.SNAPSHOT, new SnapshotDecoder());
        this.delegates.put(SubscribeType.TICK, new TickDecoder());
    }

    @Override
    public MarketData decode(MqttPublish in) {
        int interval;
        SubscribeType subscribeType;
        String topic = in.getTopic();
        String[] metaArray = topic.split(SPLITER);
        if (metaArray.length < 3) {
            logger.warn("Unrecognized topic={}.", (Object)topic);
            return null;
        }
        String instrumentId = metaArray[0];
        try {
            Optional subscribeTypeOpt = SubscribeType.fromCode((int)Integer.parseInt(metaArray[1]));
            if (!subscribeTypeOpt.isPresent()) {
                logger.warn("Unrecognized data type={}.", (Object)metaArray[1]);
                return null;
            }
            subscribeType = (SubscribeType)subscribeTypeOpt.get();
            interval = Integer.parseInt(metaArray[2]);
        }
        catch (NumberFormatException e) {
            logger.error("Unrecognized topic={}.", new Object[]{topic, e});
            return null;
        }
        Metadata metadata = new Metadata(instrumentId, subscribeType, interval);
        QuotesPublishDecoder<? extends QuotesBasic> delegate = this.delegates.get(subscribeType);
        QuotesPublish delegateOut = (QuotesPublish)delegate.decode(in.getPayload());
        return new MarketData(metadata, delegateOut);
    }
}

