/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.quotes.internal.mqtt.codec;

import com.google.protobuf.InvalidProtocolBufferException;
import com.webull.openapi.quotes.domain.Snapshot;
import com.webull.openapi.quotes.internal.mqtt.codec.Quotes;
import com.webull.openapi.quotes.internal.mqtt.codec.QuotesPublishDecoder;
import com.webull.openapi.quotes.subsribe.exception.DecoderException;
import com.webull.openapi.quotes.subsribe.message.QuotesPublish;
import java.nio.ByteBuffer;

public class SnapshotDecoder
implements QuotesPublishDecoder<Snapshot> {
    @Override
    public QuotesPublish<Snapshot> decode(ByteBuffer in) {
        try {
            Quotes.Snapshot from = Quotes.Snapshot.parseFrom(in);
            Snapshot snapshot = new Snapshot();
            snapshot.setSymbol(from.getBasic().getSymbol());
            snapshot.setInstrumentId(from.getBasic().getInstrumentId());
            snapshot.setTradeTime(from.getTradeTime());
            snapshot.setPrice(from.getPrice());
            snapshot.setOpen(from.getOpen());
            snapshot.setHigh(from.getHigh());
            snapshot.setLow(from.getLow());
            snapshot.setPreClose(from.getPreClose());
            snapshot.setVolume(from.getVolume());
            snapshot.setChange(from.getChange());
            snapshot.setChangeRatio(from.getChangeRatio());
            return new QuotesPublish<Snapshot>(from.getBasic().getTimestamp(), snapshot);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecoderException("Decode snapshot data error", e);
        }
    }
}

