/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.quotes.internal.mqtt.codec;

import com.google.protobuf.InvalidProtocolBufferException;
import com.webull.openapi.quotes.domain.Tick;
import com.webull.openapi.quotes.internal.mqtt.codec.Quotes;
import com.webull.openapi.quotes.internal.mqtt.codec.QuotesPublishDecoder;
import com.webull.openapi.quotes.subsribe.exception.DecoderException;
import com.webull.openapi.quotes.subsribe.message.QuotesPublish;
import java.nio.ByteBuffer;

public class TickDecoder
implements QuotesPublishDecoder<Tick> {
    @Override
    public QuotesPublish<Tick> decode(ByteBuffer in) throws DecoderException {
        try {
            Quotes.Tick from = Quotes.Tick.parseFrom(in);
            Tick tick = new Tick();
            tick.setSymbol(from.getBasic().getSymbol());
            tick.setInstrumentId(from.getBasic().getInstrumentId());
            tick.setTime(from.getTime());
            tick.setPrice(from.getPrice());
            tick.setVolume(from.getVolume());
            tick.setSide(from.getSide());
            return new QuotesPublish<Tick>(from.getBasic().getTimestamp(), tick);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecoderException("Decode tick data error", e);
        }
    }
}

