/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.quotes.internal.mqtt.lifecycle;

import com.webull.openapi.grpc.exception.UserCancelledException;
import com.webull.openapi.logger.Logger;
import com.webull.openapi.logger.LoggerFactory;
import com.webull.openapi.quotes.api.QuotesApiClient;
import com.webull.openapi.quotes.internal.mqtt.lifecycle.QuotesApiFailedContext;
import com.webull.openapi.quotes.internal.mqtt.support.SchedulerConfig;
import com.webull.openapi.quotes.subsribe.lifecycle.AuthProvider;
import com.webull.openapi.quotes.subsribe.lifecycle.ClientStateMachine;
import com.webull.openapi.retry.RetryContext;
import com.webull.openapi.retry.RetryPolicy;
import com.webull.openapi.utils.Assert;
import io.reactivex.Single;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class ApiAuthProvider
implements AuthProvider {
    private static final Logger logger = LoggerFactory.getLogger(ApiAuthProvider.class);
    private final String appKey;
    private volatile String token;
    private final QuotesApiClient apiClient;
    private volatile boolean isClosed = false;

    public ApiAuthProvider(String appKey, QuotesApiClient apiClient) {
        Assert.notBlank((String)"appKey", (String)appKey);
        Assert.notNull((String)"apiClient", (Object)apiClient);
        this.appKey = appKey;
        this.apiClient = apiClient;
    }

    @Override
    public String getAppKey() {
        return this.appKey;
    }

    @Override
    public Optional<String> getToken() {
        return Optional.ofNullable(this.token);
    }

    @Override
    public Single<String> refreshToken() {
        return Single.fromCallable(() -> {
            this.token = this.apiClient.getToken();
            return this.token;
        }).subscribeOn(SchedulerConfig.api());
    }

    @Override
    public Single<String> refreshToken(ClientStateMachine state, RetryPolicy retryPolicy) {
        return Single.defer(() -> {
            try {
                this.token = this.getTokenLoop(retryPolicy, new QuotesApiFailedContext(state, 0, null));
                return Single.just((Object)this.token);
            }
            catch (Exception e) {
                return Single.error((Throwable)e);
            }
        }).subscribeOn(SchedulerConfig.api());
    }

    private String getTokenLoop(RetryPolicy retryPolicy, QuotesApiFailedContext context) {
        if (this.isClosed) {
            throw new UserCancelledException();
        }
        try {
            return this.apiClient.getToken();
        }
        catch (Exception ex) {
            if (!(ex instanceof UserCancelledException)) {
                logger.error("Get token error when subscribing quotes.", (Throwable)ex);
            }
            if (retryPolicy.shouldRetry((RetryContext)context)) {
                try {
                    Thread.sleep(retryPolicy.nextRetryDelay((RetryContext)context, TimeUnit.MILLISECONDS));
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
                return this.getTokenLoop(retryPolicy, new QuotesApiFailedContext(context.getState(), context.getRetriesAttempted() + 1, ex));
            }
            throw ex;
        }
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.apiClient.close();
    }
}

