/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.quotes.internal.mqtt.lifecycle;

import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedContext;
import com.hivemq.client.mqtt.lifecycle.MqttClientReconnector;
import com.hivemq.client.mqtt.lifecycle.MqttDisconnectSource;
import com.hivemq.client.mqtt.mqtt3.exceptions.Mqtt3ConnAckException;
import com.hivemq.client.mqtt.mqtt3.message.connect.connack.Mqtt3ConnAck;
import com.webull.openapi.quotes.subsribe.lifecycle.ClientStateMachine;
import com.webull.openapi.quotes.subsribe.lifecycle.QuotesSubsFailedContext;
import java.util.Optional;

public class MqttDisconnectedContextAdapter
implements QuotesSubsFailedContext {
    private final ClientStateMachine state;
    private final MqttClientDisconnectedContext mqttClientDisconnectedContext;
    private boolean throttled;

    private MqttDisconnectedContextAdapter(ClientStateMachine state, MqttClientDisconnectedContext mqttClientDisconnectedContext) {
        this.state = state;
        this.mqttClientDisconnectedContext = mqttClientDisconnectedContext;
    }

    public static MqttDisconnectedContextAdapter of(ClientStateMachine state, MqttClientDisconnectedContext mqttClientDisconnectedContext) {
        return new MqttDisconnectedContextAdapter(state, mqttClientDisconnectedContext);
    }

    @Override
    public Optional<Integer> getConnAck() {
        Throwable cause = this.mqttClientDisconnectedContext.getCause();
        if (cause instanceof Mqtt3ConnAckException) {
            Mqtt3ConnAckException connAckEx = (Mqtt3ConnAckException)cause;
            Mqtt3ConnAck connAck = connAckEx.getMqttMessage();
            return Optional.of(connAck.getReturnCode().getCode());
        }
        return Optional.empty();
    }

    @Override
    public boolean userDisconnect() {
        return MqttDisconnectSource.USER == this.mqttClientDisconnectedContext.getSource();
    }

    @Override
    public boolean clientDisconnect() {
        return MqttDisconnectSource.CLIENT == this.mqttClientDisconnectedContext.getSource();
    }

    @Override
    public boolean serverDisconnect() {
        return MqttDisconnectSource.SERVER == this.mqttClientDisconnectedContext.getSource();
    }

    @Override
    public ClientStateMachine getState() {
        return this.state;
    }

    public int getRetriesAttempted() {
        return this.getReconnector().getAttempts();
    }

    public Throwable getCause() {
        return this.mqttClientDisconnectedContext.getCause();
    }

    public boolean throttled() {
        return this.throttled;
    }

    public void setThrottled(boolean throttled) {
        this.throttled = throttled;
    }

    MqttClientReconnector getReconnector() {
        return this.mqttClientDisconnectedContext.getReconnector();
    }

    MqttClientReconnector get() {
        return this.mqttClientDisconnectedContext.getReconnector();
    }
}

