/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.quotes.internal.mqtt.lifecycle;

import com.hivemq.client.internal.rx.RxFutureConverter;
import com.webull.openapi.execption.ClientException;
import com.webull.openapi.logger.Logger;
import com.webull.openapi.logger.LoggerFactory;
import com.webull.openapi.quotes.subsribe.lifecycle.ClientStateMachine;
import io.reactivex.Completable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public class QuotesClientState
implements ClientStateMachine {
    private static final Logger logger = LoggerFactory.getLogger(QuotesClientState.class);
    private static final CompletableFuture<Boolean> DISCONNECTED = CompletableFuture.completedFuture(true);
    private final AtomicReference<CompletableFuture<Boolean>> state = new AtomicReference<CompletableFuture<Boolean>>(DISCONNECTED);
    private final AtomicBoolean userCalledDisconnect = new AtomicBoolean(false);
    private volatile boolean isClosed = false;

    @Override
    public boolean callConnect() {
        if (this.isClosed) {
            throw new ClientException("InvalidState", "Quotes client closed.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("User call connect.");
        }
        if (this.state.compareAndSet(DISCONNECTED, new CompletableFuture())) {
            this.userCalledDisconnect.set(false);
            return true;
        }
        return false;
    }

    @Override
    public boolean connected() {
        CompletableFuture<Boolean> connectFuture = this.state.get();
        if (connectFuture != DISCONNECTED) {
            if (logger.isDebugEnabled()) {
                logger.debug("Quotes client connected.");
            }
            connectFuture.complete(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean connectFailed() {
        CompletableFuture<Boolean> connectFuture = this.state.get();
        if (connectFuture != DISCONNECTED) {
            if (logger.isDebugEnabled()) {
                logger.debug("Quotes client connect failed.");
            }
            connectFuture.complete(false);
            return true;
        }
        return false;
    }

    @Override
    public Completable callDisconnect(@Nullable Runnable doOnDisconnect) {
        if (logger.isDebugEnabled()) {
            logger.debug("User call disconnect.");
        }
        if (!this.userCalledDisconnect.compareAndSet(false, true)) {
            return Completable.complete();
        }
        CompletableFuture<Boolean> connectFuture = this.state.get();
        if (connectFuture != DISCONNECTED) {
            connectFuture.thenAccept(ignore -> {
                if (doOnDisconnect != null) {
                    try {
                        doOnDisconnect.run();
                    }
                    catch (Exception e) {
                        logger.error("Do on disconnect error", (Throwable)e);
                    }
                }
                this.state.set(DISCONNECTED);
                if (logger.isDebugEnabled()) {
                    logger.debug("Quotes client disconnected.");
                }
            });
            return RxFutureConverter.toCompletable(connectFuture);
        }
        return Completable.complete();
    }

    @Override
    public boolean userCalledDisconnect() {
        return this.isClosed || this.userCalledDisconnect.get();
    }

    @Override
    public boolean isDisconnected() {
        return DISCONNECTED == this.state.get();
    }

    @Override
    public void close() {
        this.isClosed = true;
    }
}

