/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.quotes.internal.mqtt.lifecycle;

import com.hivemq.client.mqtt.mqtt3.lifecycle.Mqtt3ClientReconnector;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3ConnectBuilder;
import com.webull.openapi.logger.Logger;
import com.webull.openapi.logger.LoggerFactory;
import com.webull.openapi.quotes.internal.mqtt.lifecycle.MqttDisconnectedContextAdapter;
import com.webull.openapi.quotes.subsribe.lifecycle.AuthProvider;
import com.webull.openapi.quotes.subsribe.lifecycle.QuotesSubsConnectedContext;
import com.webull.openapi.quotes.subsribe.lifecycle.QuotesSubsFailedContext;
import com.webull.openapi.quotes.subsribe.lifecycle.QuotesSubsSessionHandler;
import com.webull.openapi.retry.RetryContext;
import com.webull.openapi.retry.RetryPolicy;
import com.webull.openapi.utils.Assert;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;

public class QuotesSubsReconnectHandler
implements QuotesSubsSessionHandler {
    private static final Logger logger = LoggerFactory.getLogger(QuotesSubsReconnectHandler.class);
    private final String appKey;
    private final AuthProvider authProvider;
    private final RetryPolicy retryPolicy;

    public QuotesSubsReconnectHandler(String appKey, AuthProvider authProvider, RetryPolicy retryPolicy) {
        Assert.notBlank((String)"appKey", (String)appKey);
        Assert.notNull((String)"authProvider", (Object)authProvider);
        Assert.notNull((String)"retryPolicy", (Object)retryPolicy);
        this.appKey = appKey;
        this.authProvider = authProvider;
        this.retryPolicy = retryPolicy;
    }

    @Override
    public void onConnected(QuotesSubsConnectedContext context) {
    }

    @Override
    public void onDisconnected(QuotesSubsFailedContext context) {
        if (!(context instanceof MqttDisconnectedContextAdapter)) {
            logger.error("Unsupported context class type: {}", (Object)context.getClass().getName());
            return;
        }
        MqttDisconnectedContextAdapter adapter = (MqttDisconnectedContextAdapter)context;
        Mqtt3ClientReconnector reconnector = (Mqtt3ClientReconnector)adapter.getReconnector();
        boolean reconnect = this.retryPolicy.shouldRetry((RetryContext)context);
        if (reconnect) {
            try {
                String token = (String)this.authProvider.refreshToken().blockingGet();
                ((Mqtt3ConnectBuilder.Nested)((Mqtt3SimpleAuthBuilder.Nested.Complete)((Mqtt3SimpleAuthBuilder.Nested.Complete)reconnector.connectWith().simpleAuth().username(this.appKey)).password(token.getBytes(StandardCharsets.UTF_8))).applySimpleAuth()).applyConnect();
            }
            catch (Exception e) {
                logger.error("Retrieve token error when reconnecting, use old token.", (Throwable)e);
            }
            long delayNanos = this.retryPolicy.nextRetryDelay((RetryContext)context, TimeUnit.NANOSECONDS);
            reconnector.delay(delayNanos, TimeUnit.NANOSECONDS);
        } else {
            context.getState().connectFailed();
        }
        reconnector.reconnect(reconnect);
    }
}

