/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.quotes.internal.mqtt.lifecycle.binder;

import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientBuilder;
import com.webull.openapi.quotes.internal.mqtt.lifecycle.MqttConnectedContextAdapter;
import com.webull.openapi.quotes.internal.mqtt.lifecycle.MqttDisconnectedContextAdapter;
import com.webull.openapi.quotes.internal.mqtt.lifecycle.binder.MqttClientHandlerBinder;
import com.webull.openapi.quotes.subsribe.lifecycle.AuthProvider;
import com.webull.openapi.quotes.subsribe.lifecycle.ClientStateMachine;
import com.webull.openapi.quotes.subsribe.lifecycle.QuotesSubsHandler;
import com.webull.openapi.quotes.subsribe.lifecycle.QuotesSubsSessionHandler;

public final class MqttSessionHandlerBinder
implements MqttClientHandlerBinder {
    private static final MqttSessionHandlerBinder instance = new MqttSessionHandlerBinder();

    private MqttSessionHandlerBinder() {
    }

    public static MqttSessionHandlerBinder getInstance() {
        return instance;
    }

    @Override
    public int order(QuotesSubsHandler handler) {
        return handler instanceof QuotesSubsSessionHandler ? 0 : -1;
    }

    @Override
    public Mqtt3ClientBuilder bindOnSession(QuotesSubsHandler handler, ClientStateMachine state, AuthProvider authProvider, Mqtt3ClientBuilder builder) {
        QuotesSubsSessionHandler sessionHandler = (QuotesSubsSessionHandler)handler;
        return (Mqtt3ClientBuilder)((Mqtt3ClientBuilder)builder.addConnectedListener(context -> {
            MqttConnectedContextAdapter adapter = MqttConnectedContextAdapter.of(state, authProvider);
            sessionHandler.onConnected(adapter);
        })).addDisconnectedListener(context -> {
            MqttDisconnectedContextAdapter adapter = MqttDisconnectedContextAdapter.of(state, context);
            sessionHandler.onDisconnected(adapter);
        });
    }
}

