/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.quotes.subsribe.retry;

import com.webull.openapi.quotes.subsribe.lifecycle.QuotesSubsFailedContext;
import com.webull.openapi.retry.RetryContext;
import com.webull.openapi.retry.condition.RetryCondition;
import com.webull.openapi.utils.ExceptionUtils;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

public class QuotesSubsRetryCondition
implements RetryCondition {
    private QuotesSubsRetryCondition() {
    }

    public static QuotesSubsRetryCondition getInstance() {
        return InstanceHolder.instance;
    }

    public boolean shouldRetry(RetryContext context) {
        int connAck;
        if (!(context instanceof QuotesSubsFailedContext)) {
            throw new IllegalArgumentException("Retry context[" + context.getClass().getName() + "] is inappropriate to mqtt retry condition!");
        }
        QuotesSubsFailedContext quotesCtx = (QuotesSubsFailedContext)context;
        if (quotesCtx.userDisconnect()) {
            return false;
        }
        if (quotesCtx.getConnAck().isPresent() && (connAck = quotesCtx.getConnAck().get().intValue()) != 3 && connAck != 5) {
            return false;
        }
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)quotesCtx.getCause());
        return !quotesCtx.clientDisconnect() || rootCause instanceof IOException || rootCause instanceof TimeoutException;
    }

    private static class InstanceHolder {
        private static final QuotesSubsRetryCondition instance = new QuotesSubsRetryCondition();

        private InstanceHolder() {
        }
    }
}

