/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.samples.data;

import com.webull.openapi.core.common.dict.Category;
import com.webull.openapi.core.common.dict.Timespan;
import com.webull.openapi.core.http.HttpApiConfig;
import com.webull.openapi.core.logger.Logger;
import com.webull.openapi.core.logger.LoggerFactory;
import com.webull.openapi.data.quotes.domain.BatchBarResponse;
import com.webull.openapi.data.quotes.domain.Quote;
import com.webull.openapi.data.quotes.domain.Tick;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DataClient {
    private static final Logger logger = LoggerFactory.getLogger(DataClient.class);

    public static void main(String[] args) {
        HttpApiConfig apiConfig = HttpApiConfig.builder().appKey("<your_app_key>").appSecret("<your_app_secret>").regionId("<your_region_id>").build();
        com.webull.openapi.data.DataClient dataClient = new com.webull.openapi.data.DataClient(apiConfig);
        HashSet<String> symbols = new HashSet<String>();
        symbols.add("AAPL");
        symbols.add("TSLA");
        ArrayList<String> tradingSessions = new ArrayList<String>();
        tradingSessions.add("PRE");
        tradingSessions.add("RTH");
        tradingSessions.add("ATH");
        List instruments = dataClient.getInstruments(symbols, Category.US_STOCK.name());
        logger.info("Instruments: {}", (Object)instruments);
        List bars = dataClient.getBars("AAPL", Category.US_STOCK.name(), Timespan.M1.name(), 10, Boolean.valueOf(true), tradingSessions);
        logger.info("Bars: {}", (Object)bars);
        BatchBarResponse batchBars = dataClient.getBatchBars(new ArrayList(symbols), Category.US_STOCK.name(), Timespan.M1.name(), 10, Boolean.valueOf(true), tradingSessions);
        logger.info("Batch bars: {}", (Object)batchBars);
        List snapshots = dataClient.getSnapshots(symbols, Category.US_STOCK.name(), Boolean.valueOf(true), Boolean.valueOf(false));
        logger.info("Snapshots: {}", (Object)snapshots);
        Quote quote = dataClient.getQuote("AAPL", Category.US_STOCK.name(), "1", Boolean.valueOf(false));
        logger.info("Quote: {}", (Object)quote);
        Tick tick = dataClient.getTicks("AAPL", Category.US_STOCK.name(), 100, tradingSessions);
        logger.info("Tick: {}", (Object)tick);
    }
}

