/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.samples.order;

import com.webull.openapi.core.common.dict.ComboType;
import com.webull.openapi.core.common.dict.EntrustType;
import com.webull.openapi.core.common.dict.InstrumentSuperType;
import com.webull.openapi.core.common.dict.OrderSide;
import com.webull.openapi.core.common.dict.OrderTIF;
import com.webull.openapi.core.common.dict.OrderType;
import com.webull.openapi.core.http.HttpApiConfig;
import com.webull.openapi.core.logger.Logger;
import com.webull.openapi.core.logger.LoggerFactory;
import com.webull.openapi.core.utils.GUID;
import com.webull.openapi.trade.TradeClientV2;
import com.webull.openapi.trade.request.v2.TradeOrder;
import com.webull.openapi.trade.request.v2.TradeOrderItem;
import com.webull.openapi.trade.response.NOrderItem;
import com.webull.openapi.trade.response.v2.OrderHistory;
import com.webull.openapi.trade.response.v2.TradeOrderResponse;
import java.util.ArrayList;

public class OrderStockTradeClient {
    private static final Logger logger = LoggerFactory.getLogger(OrderStockTradeClient.class);

    public static void main(String[] args) {
        OrderStockTradeClient orderStockTradeClient = new OrderStockTradeClient();
        HttpApiConfig apiConfig = HttpApiConfig.builder().appKey("<your_app_key>").appSecret("<your_app_secret>").regionId("<your_region_id>").endpoint("<api_endpoint>").build();
        String accountId = "#{accountId}";
        String clientOrderId = GUID.get();
        TradeClientV2 apiService = new TradeClientV2(apiConfig);
        TradeOrder tradeOrder = orderStockTradeClient.buildPlaceUSStockParams(clientOrderId);
        TradeOrderResponse placeOrderResp = apiService.placeOrder(accountId, tradeOrder);
        logger.info("Place order response: {}", (Object)placeOrderResp);
        OrderHistory orderDetail = apiService.getOrderDetails(accountId, clientOrderId);
        logger.info("Order details response: {}", (Object)orderDetail);
        TradeOrder modifyTradeOrder = orderStockTradeClient.buildReplaceOrderParams(clientOrderId);
        TradeOrderResponse modifyOrderResponse = apiService.replaceOrder(accountId, modifyTradeOrder);
        logger.info("Order modify response: {}", (Object)modifyOrderResponse);
        OrderHistory orderDetail1 = apiService.getOrderDetails(accountId, clientOrderId);
        logger.info("Order orderDetail response after replace order: {}", (Object)orderDetail1);
        TradeOrder cancelOrder = new TradeOrder();
        cancelOrder.setClientOrderId(clientOrderId);
        TradeOrderResponse cancelOrderResponse = apiService.cancelOrder(accountId, cancelOrder);
        logger.info("Order cancel order response: {}", (Object)cancelOrderResponse);
        OrderHistory orderDetail2 = apiService.getOrderDetails(accountId, clientOrderId);
        logger.info("Order orderDetail response after cancel: {}", (Object)((NOrderItem)orderDetail2.getOrders().get(0)).getStatus());
    }

    private TradeOrder buildPlaceUSStockParams(String clientOrderId) {
        TradeOrder tradeOrder = new TradeOrder();
        ArrayList<TradeOrderItem> newOrders = new ArrayList<TradeOrderItem>();
        TradeOrderItem placeOne = new TradeOrderItem();
        placeOne.setClientOrderId(clientOrderId);
        placeOne.setComboType(ComboType.NORMAL.name());
        newOrders.add(placeOne);
        placeOne.setSymbol("BULL");
        placeOne.setInstrumentType(InstrumentSuperType.EQUITY.name());
        placeOne.setMarket("US");
        placeOne.setOrderType(OrderType.LIMIT.name());
        placeOne.setQuantity("1");
        placeOne.setLimitPrice("5");
        placeOne.setSupportTradingSession("ALL");
        placeOne.setSide(OrderSide.BUY.name());
        placeOne.setTimeInForce(OrderTIF.DAY.name());
        placeOne.setEntrustType(EntrustType.QTY.name());
        tradeOrder.setNewOrders(newOrders);
        return tradeOrder;
    }

    private TradeOrder buildPlaceHKStockParams(String clientOrderId) {
        TradeOrder tradeOrder = new TradeOrder();
        ArrayList<TradeOrderItem> newOrders = new ArrayList<TradeOrderItem>();
        TradeOrderItem placeOne = new TradeOrderItem();
        placeOne.setClientOrderId(clientOrderId);
        placeOne.setComboType(ComboType.NORMAL.name());
        newOrders.add(placeOne);
        placeOne.setSymbol("00700");
        placeOne.setInstrumentType(InstrumentSuperType.EQUITY.name());
        placeOne.setMarket("HK");
        placeOne.setOrderType(OrderType.ENHANCED_LIMIT.name());
        placeOne.setQuantity("100");
        placeOne.setLimitPrice("610");
        placeOne.setSide(OrderSide.BUY.name());
        placeOne.setTimeInForce(OrderTIF.DAY.name());
        placeOne.setEntrustType(EntrustType.QTY.name());
        tradeOrder.setNewOrders(newOrders);
        return tradeOrder;
    }

    private TradeOrder buildReplaceOrderParams(String clientOrderId) {
        TradeOrder replaceTradeOrder = new TradeOrder();
        ArrayList<TradeOrderItem> modifyOrders = new ArrayList<TradeOrderItem>();
        TradeOrderItem modifyOne = new TradeOrderItem();
        modifyOne.setClientOrderId(clientOrderId);
        modifyOne.setLimitPrice("5");
        modifyOne.setQuantity("2");
        modifyOrders.add(modifyOne);
        replaceTradeOrder.setModifyOrders(modifyOrders);
        return replaceTradeOrder;
    }
}

