/*
 * Copyright 2022 Webull
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.webull.openapi.data.internal.mqtt.support;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class SchedulerConfig {

    private SchedulerConfig() {
    }

    private static final ThreadFactory quotesApiThreadFactory = new ThreadFactoryBuilder()
            .setNameFormat("quotesApiScheduler-%d")
            .setDaemon(true)
            .build();
    private static final Scheduler API_SCHEDULER = Schedulers.from(Executors.newSingleThreadScheduledExecutor(quotesApiThreadFactory));

    public static Scheduler api() {
        return API_SCHEDULER;
    }
}
