/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.data.internal.mqtt.lifecycle;

import com.hivemq.client.mqtt.mqtt3.lifecycle.Mqtt3ClientReconnector;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3ConnectBuilder;
import com.webull.openapi.core.logger.Logger;
import com.webull.openapi.core.logger.LoggerFactory;
import com.webull.openapi.core.retry.RetryPolicy;
import com.webull.openapi.core.utils.Assert;
import com.webull.openapi.data.internal.mqtt.lifecycle.MqttDisconnectedContextAdapter;
import com.webull.openapi.data.quotes.subsribe.lifecycle.AuthProvider;
import com.webull.openapi.data.quotes.subsribe.lifecycle.QuotesSubsConnectedContext;
import com.webull.openapi.data.quotes.subsribe.lifecycle.QuotesSubsFailedContext;
import com.webull.openapi.data.quotes.subsribe.lifecycle.QuotesSubsSessionHandler;
import java.util.concurrent.TimeUnit;

public class QuotesSubsReconnectHandler
implements QuotesSubsSessionHandler {
    private static final Logger logger = LoggerFactory.getLogger(QuotesSubsReconnectHandler.class);
    private final String appKey;
    private final AuthProvider authProvider;
    private final RetryPolicy retryPolicy;

    public QuotesSubsReconnectHandler(String appKey, AuthProvider authProvider, RetryPolicy retryPolicy) {
        Assert.notBlank("appKey", appKey);
        Assert.notNull("authProvider", (Object)authProvider);
        Assert.notNull("retryPolicy", (Object)retryPolicy);
        this.appKey = appKey;
        this.authProvider = authProvider;
        this.retryPolicy = retryPolicy;
    }

    @Override
    public void onConnected(QuotesSubsConnectedContext context) {
    }

    @Override
    public void onDisconnected(QuotesSubsFailedContext context) {
        if (!(context instanceof MqttDisconnectedContextAdapter)) {
            logger.error("Unsupported context class type: {}", (Object)context.getClass().getName());
            return;
        }
        MqttDisconnectedContextAdapter adapter = (MqttDisconnectedContextAdapter)context;
        Mqtt3ClientReconnector reconnector = (Mqtt3ClientReconnector)adapter.getReconnector();
        boolean reconnect = this.retryPolicy.shouldRetry(context);
        if (reconnect) {
            try {
                ((Mqtt3ConnectBuilder.Nested)((Mqtt3SimpleAuthBuilder.Nested.Complete)((Mqtt3SimpleAuthBuilder.Nested.Complete)reconnector.connectWith().simpleAuth().username(this.appKey)).password("".getBytes())).applySimpleAuth()).applyConnect();
            }
            catch (Exception e) {
                logger.error("Error when reconnecting.", e);
            }
            long delayNanos = this.retryPolicy.nextRetryDelay(context, TimeUnit.NANOSECONDS);
            reconnector.delay(delayNanos, TimeUnit.NANOSECONDS);
        } else {
            context.getState().connectFailed();
        }
        reconnector.reconnect(reconnect);
    }
}

