/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.core.auth.composer;

import com.webull.openapi.core.auth.signer.Signer;
import com.webull.openapi.core.auth.signer.SignerFactory;
import com.webull.openapi.core.execption.ClientException;
import com.webull.openapi.core.http.HttpRequest;
import com.webull.openapi.core.utils.DateUtils;
import com.webull.openapi.core.utils.GUID;
import com.webull.openapi.core.utils.MD5Utils;
import com.webull.openapi.core.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultSignatureComposer {
    private static final String PARAMS_JOIN = "&";
    private static final String SECRET_TAILER = "&";
    private static final String PARAM_KV_JOIN = "=";

    private DefaultSignatureComposer() {
    }

    private static Map<String, String> refreshSignHeaders(String host, String appKey, Map<String, String> headers, Signer signer) {
        HashMap<String, String> signHeaders = new HashMap<String, String>();
        signHeaders.put("x-app-key", appKey);
        signHeaders.put("x-timestamp", DateUtils.getTimestamp());
        signHeaders.put("x-signature-version", signer.signerVersion());
        signHeaders.put("x-signature-algorithm", signer.signerName());
        signHeaders.put("x-signature-nonce", GUID.get());
        headers.putAll(signHeaders);
        signHeaders.put("Host".toLowerCase(), host);
        headers.put("Host", host);
        return signHeaders;
    }

    private static String buildSignString(Map<String, String> signParams, String uri, String payload) {
        String signString = "";
        if (StringUtils.isNotEmpty(uri)) {
            signString = uri;
        }
        List signPairs = signParams.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> (String)entry.getKey() + PARAM_KV_JOIN + (String)entry.getValue()).collect(Collectors.toList());
        signString = StringUtils.isNotEmpty(signString) ? signString + "&" + String.join((CharSequence)"&", signPairs) : String.join((CharSequence)PARAM_KV_JOIN, signPairs);
        if (StringUtils.isNotEmpty(payload)) {
            signString = signString + "&" + payload;
        }
        try {
            return URLEncoder.encode(signString, StandardCharsets.UTF_8.toString()).replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("NotSupport", e);
        }
    }

    public static String getSign(String signString, String secret, Signer signer) {
        return signer.getSign(signString, secret + "&");
    }

    public static String getSign(Map<String, String> signParams, String url, String payload, String secret, Signer signer) {
        String signString = DefaultSignatureComposer.buildSignString(signParams, url, payload);
        return DefaultSignatureComposer.getSign(signString, secret, signer);
    }

    public static String getSign(String host, String appKey, String appSecret, HttpRequest request) {
        Signer signer = SignerFactory.getInstance().get(request.getSignAlgorithm());
        Map<String, String> signParams = DefaultSignatureComposer.refreshSignHeaders(host, appKey, request.getHeaders(), signer);
        Map<String, Object> queryParams = request.getQuery();
        queryParams.forEach((key, value) -> {
            String result = signParams.containsKey(key) ? (String)signParams.get(key) + "&" + (value != null ? value : "") : String.valueOf(value);
            signParams.put((String)key, result);
        });
        String bodyString = "";
        if (request.getBodyString() != null) {
            bodyString = MD5Utils.md5(request.getBodyString().getBytes(StandardCharsets.UTF_8)).toUpperCase();
        }
        String signString = DefaultSignatureComposer.buildSignString(signParams, request.getUri(), bodyString);
        return DefaultSignatureComposer.getSign(signString, appSecret, signer);
    }
}

