/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.core.retry.condition;

import com.webull.openapi.core.logger.Logger;
import com.webull.openapi.core.logger.LoggerFactory;
import com.webull.openapi.core.retry.RetryContext;
import com.webull.openapi.core.retry.condition.RetryCondition;

public class MaxRetryTimesCondition
implements RetryCondition {
    private static final Logger logger = LoggerFactory.getLogger(MaxRetryTimesCondition.class);
    private final int maxRetries;

    public MaxRetryTimesCondition(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    @Override
    public boolean shouldRetry(RetryContext context) {
        if (context.getRetriesAttempted() < this.maxRetries) {
            return true;
        }
        logger.debug("Reached the maximum number of retry, attempts:{}", (Object)context.getRetriesAttempted());
        return false;
    }
}

