/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.core.http.initializer;

import com.webull.openapi.core.common.Region;
import com.webull.openapi.core.execption.ClientException;
import com.webull.openapi.core.http.HttpApiClient;
import com.webull.openapi.core.http.initializer.config.ConfigService;
import com.webull.openapi.core.http.initializer.config.bean.ApiConfig;
import com.webull.openapi.core.http.initializer.token.TokenManager;
import com.webull.openapi.core.logger.Logger;
import com.webull.openapi.core.logger.LoggerFactory;
import com.webull.openapi.core.utils.StringUtils;
import java.util.ArrayList;
import java.util.Objects;

public class ClientInitializer {
    private static final Logger logger = LoggerFactory.getLogger(ClientInitializer.class);

    public static void init(HttpApiClient apiClient) {
        ClientInitializer.initToken(apiClient);
    }

    private static void initToken(HttpApiClient apiClient) {
        String regionId;
        ArrayList<String> disableConfigRegionIds = new ArrayList<String>();
        disableConfigRegionIds.add(Region.hk.name());
        String string = regionId = Objects.nonNull(apiClient) && Objects.nonNull(apiClient.getConfig()) ? apiClient.getConfig().getRegionId() : null;
        if (disableConfigRegionIds.contains(regionId) ? !ClientInitializer.checkRegionTokenEnable(apiClient) : !ClientInitializer.checkTokenEnable(apiClient)) {
            return;
        }
        TokenManager tokenManager = new TokenManager();
        tokenManager.initToken(apiClient);
    }

    private static boolean checkRegionTokenEnable(HttpApiClient apiClient) {
        if (Objects.isNull(apiClient)) {
            logger.warn("CheckRegionTokenEnable apiClient is null return false");
            return false;
        }
        if (Objects.isNull(apiClient.getConfig())) {
            logger.warn("CheckRegionTokenEnable apiConfig is null return false");
            return false;
        }
        if (StringUtils.isBlank(apiClient.getConfig().getRegionId())) {
            logger.warn("CheckRegionTokenEnable regionId is blank return false");
            return false;
        }
        ArrayList<String> enableRegionIds = new ArrayList<String>();
        enableRegionIds.add(Region.hk.name());
        boolean result = enableRegionIds.contains(apiClient.getConfig().getRegionId());
        logger.info("CheckRegionTokenEnable result is {}, enable regionIds is {}.", result, enableRegionIds);
        return result;
    }

    private static boolean checkTokenEnable(HttpApiClient apiClient) {
        if (Objects.isNull(apiClient)) {
            logger.warn("checkTokenEnable apiClient is null return false");
            return false;
        }
        ConfigService configService = new ConfigService(apiClient);
        ApiConfig apiConfig = configService.getConfig();
        if (Objects.isNull(apiConfig)) {
            String msg = "checkTokenEnable apiConfig is null error.";
            logger.warn(msg);
            throw new ClientException("GetConfigError", msg);
        }
        boolean result = Boolean.TRUE.equals(apiConfig.getTokenCheckEnabled());
        logger.info("checkTokenEnable result is {}", (Object)result);
        return result;
    }
}

