/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.core.http.retry;

import com.webull.openapi.core.execption.ClientException;
import com.webull.openapi.core.execption.ServerException;
import com.webull.openapi.core.http.common.HttpMethod;
import com.webull.openapi.core.http.retry.HttpRetryContext;
import com.webull.openapi.core.retry.RetryContext;
import com.webull.openapi.core.retry.condition.RetryCondition;

public class RetryOnHttpMethodCondition
implements RetryCondition {
    @Override
    public boolean shouldRetry(RetryContext context) {
        if (!(context instanceof HttpRetryContext)) {
            throw new IllegalArgumentException("Retry context[" + context.getClass().getName() + "] is inappropriate to http retry condition!");
        }
        HttpRetryContext httpCtx = (HttpRetryContext)context;
        Throwable cause = httpCtx.getCause();
        if (cause instanceof ClientException || cause instanceof ServerException) {
            return HttpMethod.GET == httpCtx.getMethod();
        }
        return false;
    }
}

