/*
 * Copyright 2022 Webull
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.webull.openapi.core.retry.backoff;

import com.webull.openapi.core.retry.RetryContext;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

public class JitterExponentialBackoffStrategy extends ExponentialBackoffStrategy {

    public JitterExponentialBackoffStrategy(long initialDelay, long maxDelay, TimeUnit timeUnit) {
        super(initialDelay, maxDelay, timeUnit);
    }

    @Override
    public long nextRetryDelay(RetryContext context, TimeUnit timeUnit) {
        long delay = super.nextRetryDelay(context, TimeUnit.NANOSECONDS);
        // Additionally a random delay of +-25% will be added.
        long randomDelay = (long) (delay / 4d / Integer.MAX_VALUE * ThreadLocalRandom.current().nextInt());
        return timeUnit.convert(delay + randomDelay, TimeUnit.NANOSECONDS);
    }
}
