/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.trade;

import com.google.gson.reflect.TypeToken;
import com.webull.openapi.core.common.Region;
import com.webull.openapi.core.common.dict.InstrumentSuperType;
import com.webull.openapi.core.execption.ClientException;
import com.webull.openapi.core.http.HttpApiClient;
import com.webull.openapi.core.http.HttpApiConfig;
import com.webull.openapi.core.http.HttpRequest;
import com.webull.openapi.core.http.common.HttpMethod;
import com.webull.openapi.core.http.initializer.ClientInitializer;
import com.webull.openapi.core.utils.Assert;
import com.webull.openapi.core.utils.CollectionUtils;
import com.webull.openapi.core.utils.StringUtils;
import com.webull.openapi.trade.http.ITradeV3Client;
import com.webull.openapi.trade.request.v3.OptionOrderItemLeg;
import com.webull.openapi.trade.request.v3.TradeOrder;
import com.webull.openapi.trade.request.v3.TradeOrderItem;
import com.webull.openapi.trade.response.TradeCalendar;
import com.webull.openapi.trade.response.v3.Account;
import com.webull.openapi.trade.response.v3.AccountBalanceInfo;
import com.webull.openapi.trade.response.v3.AccountPositionsInfo;
import com.webull.openapi.trade.response.v3.OrderHistory;
import com.webull.openapi.trade.response.v3.PreviewOrderResponse;
import com.webull.openapi.trade.response.v3.TradeBatchPlaceResponse;
import com.webull.openapi.trade.response.v3.TradeOrderResponse;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class TradeClientV3
implements ITradeV3Client {
    private static final String ACCOUNT_ID_ARG = "accountId";
    private static final String TRADE_ORDER_ARG = "tradeOrder";
    private static final String NEW_ORDERS_ARG = "newOrders";
    private static final String BATCH_ORDERS_ARG = "batchOrders";
    private static final String MODIFY_ORDERS_ARG = "modifyOrders";
    private static final String CLIENT_ORDER_ID_ARG = "clientOrderId";
    private static final String PAGE_SIZE_PARAM = "page_size";
    private static final String START_TIME_PARAM = "start_date";
    private static final String END_TIME_PARAM = "end_date";
    private static final String LAST_CLIENT_ORDER_ID_PARAM = "last_client_order_id";
    private static final String LAST_ORDER_ID_PARAM = "last_order_id";
    private static final String ACCOUNT_ID_PARAM = "account_id";
    private static final String CLIENT_ORDER_ID_PARAM = "client_order_id";
    private static final String CLIENT_COMBO_ORDER_ID_PARAM = "client_combo_order_id";
    private static final String NEW_ORDERS_PARAM = "new_orders";
    private static final String BATCH_ORDERS_PARAM = "batch_orders";
    private static final String MODIFY_ORDERS_PARAM = "modify_orders";
    private final Region region;
    private final HttpApiClient apiClient;

    public TradeClientV3(HttpApiConfig config) {
        this(new HttpApiClient(config));
    }

    public TradeClientV3(HttpApiClient apiClient) {
        this.region = Region.of(apiClient.getConfig().getRegionId()).orElseThrow(() -> new ClientException("InvalidParameter", "Must set region id which defined in " + Region.class.getName() + " when using this service."));
        this.apiClient = apiClient;
        ClientInitializer.init(apiClient);
    }

    @Override
    public List<Account> listAccount() {
        HttpRequest request = new HttpRequest("/openapi/account/list", "v2", HttpMethod.GET);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<Account>>(){}.getType()).doAction();
    }

    @Override
    public AccountBalanceInfo balanceAccount(String accountId) {
        Assert.notBlank(ACCOUNT_ID_ARG, accountId);
        HttpRequest request = new HttpRequest("/openapi/assets/balance", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ACCOUNT_ID_PARAM, accountId);
        request.setQuery(params);
        return (AccountBalanceInfo)this.apiClient.request(request).responseType((Type)((Object)AccountBalanceInfo.class)).doAction();
    }

    @Override
    public List<AccountPositionsInfo> positionsAccount(String accountId) {
        Assert.notBlank(ACCOUNT_ID_ARG, accountId);
        HttpRequest request = new HttpRequest("/openapi/assets/positions", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ACCOUNT_ID_PARAM, accountId);
        request.setQuery(params);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<AccountPositionsInfo>>(){}.getType()).doAction();
    }

    @Override
    public PreviewOrderResponse previewOrder(String accountId, TradeOrder tradeOrder) {
        Assert.notBlank(ACCOUNT_ID_ARG, accountId);
        HttpRequest request = new HttpRequest("/openapi/trade/order/preview", "v2", HttpMethod.POST);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ACCOUNT_ID_PARAM, accountId);
        params.put(NEW_ORDERS_PARAM, tradeOrder.getNewOrders());
        if (StringUtils.isNotBlank(tradeOrder.getClientComboOrderId())) {
            params.put(CLIENT_COMBO_ORDER_ID_PARAM, tradeOrder.getClientComboOrderId());
        }
        request.setBody(params);
        return (PreviewOrderResponse)this.apiClient.request(request).responseType(new TypeToken<PreviewOrderResponse>(){}.getType()).doAction();
    }

    @Override
    public TradeOrderResponse placeOrder(String accountId, TradeOrder tradeOrder) {
        Assert.notBlank(ACCOUNT_ID_ARG, accountId);
        Assert.notNull(TRADE_ORDER_ARG, (Object)tradeOrder);
        Assert.notEmpty(NEW_ORDERS_ARG, tradeOrder.getNewOrders());
        HttpRequest request = new HttpRequest("/openapi/trade/order/place", "v2", HttpMethod.POST);
        this.addCustomHeadersFromOrder(request, tradeOrder.getNewOrders());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ACCOUNT_ID_PARAM, accountId);
        params.put(NEW_ORDERS_PARAM, tradeOrder.getNewOrders());
        if (StringUtils.isNotBlank(tradeOrder.getClientComboOrderId())) {
            params.put(CLIENT_COMBO_ORDER_ID_PARAM, tradeOrder.getClientComboOrderId());
        }
        request.setBody(params);
        return (TradeOrderResponse)this.apiClient.request(request).responseType(new TypeToken<TradeOrderResponse>(){}.getType()).doAction();
    }

    @Override
    public TradeBatchPlaceResponse batchPlaceOrder(String accountId, TradeOrder tradeOrder) {
        Assert.notBlank(ACCOUNT_ID_ARG, accountId);
        Assert.notNull(TRADE_ORDER_ARG, (Object)tradeOrder);
        Assert.notEmpty(BATCH_ORDERS_ARG, tradeOrder.getBatchOrders());
        HttpRequest request = new HttpRequest("/openapi/trade/order/batch-place", "v2", HttpMethod.POST);
        this.addCustomHeadersFromOrder(request, tradeOrder.getBatchOrders());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ACCOUNT_ID_PARAM, accountId);
        params.put(BATCH_ORDERS_PARAM, tradeOrder.getBatchOrders());
        request.setBody(params);
        return (TradeBatchPlaceResponse)this.apiClient.request(request).responseType(new TypeToken<TradeBatchPlaceResponse>(){}.getType()).doAction();
    }

    @Override
    public TradeOrderResponse replaceOrder(String accountId, TradeOrder tradeOrder) {
        Assert.notBlank(ACCOUNT_ID_ARG, accountId);
        Assert.notNull(TRADE_ORDER_ARG, (Object)tradeOrder);
        Assert.notEmpty(MODIFY_ORDERS_ARG, tradeOrder.getModifyOrders());
        HttpRequest request = new HttpRequest("/openapi/trade/order/replace", "v2", HttpMethod.POST);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ACCOUNT_ID_PARAM, accountId);
        params.put(MODIFY_ORDERS_PARAM, tradeOrder.getModifyOrders());
        if (StringUtils.isNotBlank(tradeOrder.getClientComboOrderId())) {
            params.put(CLIENT_COMBO_ORDER_ID_PARAM, tradeOrder.getClientComboOrderId());
        }
        request.setBody(params);
        return (TradeOrderResponse)this.apiClient.request(request).responseType(new TypeToken<TradeOrderResponse>(){}.getType()).doAction();
    }

    @Override
    public TradeOrderResponse cancelOrder(String accountId, TradeOrder tradeOrder) {
        Assert.notBlank(ACCOUNT_ID_ARG, accountId);
        Assert.notNull(TRADE_ORDER_ARG, (Object)tradeOrder);
        Assert.notBlank(CLIENT_ORDER_ID_ARG, tradeOrder.getClientOrderId());
        HttpRequest request = new HttpRequest("/openapi/trade/order/cancel", "v2", HttpMethod.POST);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(ACCOUNT_ID_PARAM, accountId);
        params.put(CLIENT_ORDER_ID_PARAM, tradeOrder.getClientOrderId());
        if (StringUtils.isNotBlank(tradeOrder.getClientComboOrderId())) {
            params.put(CLIENT_COMBO_ORDER_ID_PARAM, tradeOrder.getClientComboOrderId());
        }
        request.setBody(params);
        return (TradeOrderResponse)this.apiClient.request(request).responseType(new TypeToken<TradeOrderResponse>(){}.getType()).doAction();
    }

    @Override
    public List<OrderHistory> listOrders(String accountId, Integer pageSize, String startDate, String endDate, String lastClientOrderId) {
        Assert.notBlank(ACCOUNT_ID_ARG, accountId);
        HttpRequest request = new HttpRequest("/openapi/trade/order/history", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ACCOUNT_ID_PARAM, accountId);
        params.put(PAGE_SIZE_PARAM, pageSize == null ? 10 : pageSize);
        if (StringUtils.isNotEmpty(lastClientOrderId)) {
            params.put(LAST_CLIENT_ORDER_ID_PARAM, lastClientOrderId);
        }
        if (StringUtils.isNotEmpty(startDate)) {
            params.put(START_TIME_PARAM, startDate);
        }
        if (StringUtils.isNotEmpty(endDate)) {
            params.put(END_TIME_PARAM, endDate);
        }
        request.setQuery(params);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<OrderHistory>>(){}.getType()).doAction();
    }

    @Override
    public List<OrderHistory> openOrders(String accountId, Integer pageSize, String lastClientOrderId) {
        Assert.notBlank(ACCOUNT_ID_ARG, accountId);
        HttpRequest request = new HttpRequest("/openapi/trade/order/open", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ACCOUNT_ID_PARAM, accountId);
        params.put(PAGE_SIZE_PARAM, pageSize == null ? 10 : pageSize);
        if (StringUtils.isNotEmpty(lastClientOrderId)) {
            params.put(LAST_CLIENT_ORDER_ID_PARAM, lastClientOrderId);
        }
        request.setQuery(params);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<OrderHistory>>(){}.getType()).doAction();
    }

    @Override
    public OrderHistory getOrderDetails(String accountId, String clientOrderId) {
        Assert.notBlank(Arrays.asList(ACCOUNT_ID_ARG, CLIENT_ORDER_ID_ARG), accountId, clientOrderId);
        HttpRequest request = new HttpRequest("/openapi/trade/order/detail", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ACCOUNT_ID_PARAM, accountId);
        params.put(CLIENT_ORDER_ID_PARAM, clientOrderId);
        request.setQuery(params);
        return (OrderHistory)this.apiClient.request(request).responseType((Type)((Object)OrderHistory.class)).doAction();
    }

    @Override
    public List<TradeCalendar> getTradeCalendar(String market, String start, String end) {
        return Collections.emptyList();
    }

    private void addCustomHeadersFromOrder(HttpRequest request, List<TradeOrderItem> orders) {
        if (CollectionUtils.isEmpty(orders) || Objects.isNull(orders.get(0))) {
            return;
        }
        TradeOrderItem tradeOrderItem = orders.get(0);
        if (CollectionUtils.isEmpty(tradeOrderItem.getLegs())) {
            List<String> categoryList = Arrays.asList(tradeOrderItem.getMarket(), tradeOrderItem.getInstrumentType());
            String category = StringUtils.join(categoryList, "_");
            if (StringUtils.isNotBlank(category)) {
                request.getHeaders().put("category", category);
            }
        } else {
            OptionOrderItemLeg item = tradeOrderItem.getLegs().stream().filter(v -> Objects.nonNull(v) && Objects.equals(InstrumentSuperType.OPTION.name(), v.getInstrumentType())).findFirst().orElse(null);
            if (Objects.isNull(item)) {
                return;
            }
            List<String> categoryList = Arrays.asList(item.getMarket(), item.getInstrumentType());
            String category = StringUtils.join(categoryList, "_");
            if (StringUtils.isNotBlank(category)) {
                request.getHeaders().put("category", category);
            }
        }
    }
}

