/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.trade.events.internal;

import com.webull.openapi.core.execption.ClientException;
import com.webull.openapi.trade.events.subscribe.ISubscription;
import com.webull.openapi.trade.grpc.StatefulResponseObserver;
import java.util.concurrent.CompletableFuture;

public final class CancellableISubscription
implements ISubscription {
    private final StatefulResponseObserver<?, ?> observer;

    public CancellableISubscription(StatefulResponseObserver<?, ?> observer) {
        this.observer = observer;
    }

    @Override
    public void unsubscribe() {
        this.observer.cancel();
    }

    @Override
    public CompletableFuture<Void> completable() {
        return this.observer.observingFuture();
    }

    @Override
    public void blockingAwait() {
        try {
            this.observer.observingFuture().get();
        }
        catch (InterruptedException interrupted) {
            Thread.currentThread().interrupt();
            throw new ClientException("Waiting for result interrupted.", interrupted);
        }
        catch (Exception ex) {
            throw new ClientException("Error waiting for result.", ex);
        }
    }
}

