/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.core.common.dict;

import com.webull.openapi.core.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum SubscribeType {
    QUOTE(0, "quote"),
    SNAPSHOT(1, "snapshot"),
    TICK(2, "tick");

    private final int code;
    private final String type;
    private static final SubscribeType[] items;
    private static Map<String, SubscribeType> typeItemMap;

    private SubscribeType(int code, String type) {
        this.code = code;
        this.type = type;
    }

    public int getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }

    public static Optional<SubscribeType> fromCode(int code) {
        if (code < 0 || code > items.length - 1) {
            return Optional.empty();
        }
        return Optional.ofNullable(items[code]);
    }

    public static Optional<SubscribeType> fromType(String type) {
        if (StringUtils.isBlank(type)) {
            return Optional.empty();
        }
        return Optional.ofNullable(typeItemMap.get(type));
    }

    static {
        items = new SubscribeType[SubscribeType.values().length];
        typeItemMap = new HashMap<String, SubscribeType>();
        SubscribeType[] subscribeTypeArray = SubscribeType.values();
        int n = subscribeTypeArray.length;
        for (int i = 0; i < n; ++i) {
            SubscribeType item;
            SubscribeType.items[item.getCode()] = item = subscribeTypeArray[i];
            typeItemMap.put(item.getType(), item);
        }
    }
}

