/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.core.http.okhttp;

import com.webull.openapi.core.http.HttpRequest;
import com.webull.openapi.core.http.okhttp.OkHttpRequestBody;
import java.net.URL;
import java.util.Map;
import okhttp3.Request;
import okhttp3.RequestBody;

public class OkHttpRequestBuilder {
    private final HttpRequest request;
    private final Request.Builder builder;

    public static OkHttpRequestBuilder newRequest(HttpRequest request) {
        return new OkHttpRequestBuilder(request);
    }

    private OkHttpRequestBuilder(HttpRequest request) {
        this.request = request;
        this.builder = new Request.Builder();
    }

    public OkHttpRequestBuilder url(URL url) {
        this.builder.url(url);
        return this;
    }

    public OkHttpRequestBuilder header(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.builder.header(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Request build() {
        switch (this.request.getMethod()) {
            case DELETE: {
                OkHttpRequestBody requestBody = new OkHttpRequestBody(this.request);
                this.builder.delete((RequestBody)requestBody);
                break;
            }
            case POST: {
                OkHttpRequestBody requestBody = new OkHttpRequestBody(this.request);
                this.builder.post((RequestBody)requestBody);
                break;
            }
            case PUT: {
                OkHttpRequestBody requestBody = new OkHttpRequestBody(this.request);
                this.builder.put((RequestBody)requestBody);
                break;
            }
            case PATCH: {
                OkHttpRequestBody requestBody = new OkHttpRequestBody(this.request);
                this.builder.patch((RequestBody)requestBody);
                break;
            }
            case HEAD: {
                this.builder.head();
                break;
            }
            default: {
                this.builder.get();
            }
        }
        return this.builder.build();
    }
}

