/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.data.internal.mqtt.codec;

import com.google.protobuf.InvalidProtocolBufferException;
import com.webull.openapi.data.internal.mqtt.codec.Quotes;
import com.webull.openapi.data.internal.mqtt.codec.QuotesPublishDecoder;
import com.webull.openapi.data.quotes.domain.Snapshot;
import com.webull.openapi.data.quotes.subsribe.exception.DecoderException;
import com.webull.openapi.data.quotes.subsribe.message.QuotesPublish;
import java.nio.ByteBuffer;

public class SnapshotDecoder
implements QuotesPublishDecoder<Snapshot> {
    @Override
    public QuotesPublish<Snapshot> decode(ByteBuffer in) {
        try {
            Quotes.Snapshot from = Quotes.Snapshot.parseFrom(in);
            Snapshot snapshot = new Snapshot();
            snapshot.setSymbol(from.getBasic().getSymbol());
            snapshot.setInstrumentId(from.getBasic().getInstrumentId());
            snapshot.setLastTradeTime(from.getTradeTime().isEmpty() ? null : Long.valueOf(Long.parseLong(from.getTradeTime())));
            snapshot.setPrice(from.getPrice());
            snapshot.setOpen(from.getOpen());
            snapshot.setHigh(from.getHigh());
            snapshot.setLow(from.getLow());
            snapshot.setPreClose(from.getPreClose());
            snapshot.setClose(from.getPrice());
            snapshot.setVolume(from.getVolume());
            snapshot.setChange(from.getChange());
            snapshot.setChangeRatio(from.getChangeRatio());
            snapshot.setTradingSession(from.getBasic().getTradingSession());
            snapshot.setExtendHourLastTradeTime(from.getExtTradeTime().isEmpty() ? null : Long.valueOf(Long.parseLong(from.getExtTradeTime())));
            snapshot.setExtendHourLastPrice(from.getExtPrice());
            snapshot.setExtendHourHigh(from.getExtHigh());
            snapshot.setExtendHourLow(from.getExtLow());
            snapshot.setExtendHourVolume(from.getExtVolume());
            snapshot.setExtendHourChange(from.getExtChange());
            snapshot.setExtendHourChangeRatio(from.getExtChangeRatio());
            snapshot.setOvnLastTradeTime(from.getOvnTradeTime().isEmpty() ? null : Long.valueOf(Long.parseLong(from.getOvnTradeTime())));
            snapshot.setOvnPrice(from.getOvnPrice());
            snapshot.setOvnHigh(from.getOvnHigh());
            snapshot.setOvnLow(from.getOvnLow());
            snapshot.setOvnVolume(from.getOvnVolume());
            snapshot.setOvnChange(from.getOvnChange());
            snapshot.setOvnChangeRatio(from.getOvnChangeRatio());
            return new QuotesPublish<Snapshot>(from.getBasic().getTimestamp(), snapshot);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecoderException("Decode snapshot data error", e);
        }
    }
}

