/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.data.quotes.api.subsribe;

import com.webull.openapi.core.http.HttpApiClient;
import com.webull.openapi.core.http.HttpApiConfig;
import com.webull.openapi.core.http.HttpRequest;
import com.webull.openapi.core.http.common.HttpMethod;
import com.webull.openapi.core.http.initializer.ClientInitializer;
import com.webull.openapi.core.utils.Assert;
import com.webull.openapi.core.utils.CollectionUtils;
import com.webull.openapi.core.utils.StringUtils;
import com.webull.openapi.data.quotes.api.subsribe.IMarketStreamingClient;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;

public class MarketStreamingClient
implements IMarketStreamingClient {
    private static final String NOT_SUPPORT_MSG = "Http client not support for this method, please use default grpc client.";
    private final HttpApiClient apiClient;
    private String userId;

    public MarketStreamingClient(HttpApiConfig config) {
        this.apiClient = new HttpApiClient(config);
        ClientInitializer.init(this.apiClient);
    }

    public MarketStreamingClient(HttpApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public MarketStreamingClient setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    @Override
    public void subscribe(String sessionId, Set<String> symbols, String category, Set<String> subTypes, String depth, Boolean overnightRequired) {
        Assert.notBlank("session_id", sessionId);
        Assert.notEmpty("symbols", symbols);
        Assert.notBlank("category", category);
        Assert.notEmpty("sub_types", subTypes);
        HttpRequest request = new HttpRequest("/market-data/streaming/subscribe", "v2", HttpMethod.POST);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("session_id", sessionId);
        params.put("symbols", symbols);
        params.put("category", category);
        params.put("sub_types", subTypes);
        if (StringUtils.isNotBlank(depth)) {
            params.put("depth", depth);
        }
        if (Objects.nonNull(overnightRequired)) {
            params.put("overnight_required", overnightRequired);
        }
        request.setBody(params);
        this.apiClient.request(request).doVoidAction();
    }

    @Override
    public void unsubscribe(String sessionId, Set<String> symbols, String category, Set<String> subTypes, Boolean unsubscribeAll) {
        Assert.notBlank("session_id", sessionId);
        HttpRequest request = new HttpRequest("/market-data/streaming/unsubscribe", "v2", HttpMethod.POST);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("session_id", sessionId);
        if (CollectionUtils.isNotEmpty(symbols)) {
            params.put("symbols", symbols);
        }
        if (StringUtils.isNotBlank(category)) {
            params.put("category", category);
        }
        if (CollectionUtils.isNotEmpty(subTypes)) {
            params.put("sub_types", subTypes);
        }
        if (unsubscribeAll != null) {
            params.put("unsubscribe_all", unsubscribeAll);
        }
        request.setBody(params);
        this.apiClient.request(request).doVoidAction();
    }
}

