/*
 * Copyright 2022 Webull
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.webull.openapi.core.utils;

import java.util.UUID;

public final class GUID {
    private GUID() {
    }

    public static String get() {
        UUID uuid = UUID.randomUUID();
        StringBuilder sb = new StringBuilder();
        get(sb, uuid.getMostSignificantBits());
        get(sb, uuid.getLeastSignificantBits());
        return sb.toString();
    }

    private static StringBuilder get(StringBuilder sb, long bits) {
        for (int var3 = 13; var3-- > 0; bits >>>= 5) {
            long low = bits & 31L;
            if (low < 10L) {
                sb.append((char) ((int) (48L + low)));
            } else {
                sb.append((char) ((int) (65L + (low - 10L))));
            }
        }
        return sb;
    }
}