/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.core.http;

import com.webull.openapi.core.auth.composer.DefaultSignatureComposer;
import com.webull.openapi.core.config.ProjectReaderHelper;
import com.webull.openapi.core.execption.ClientException;
import com.webull.openapi.core.execption.ServerException;
import com.webull.openapi.core.http.HttpApiConfig;
import com.webull.openapi.core.http.HttpRequest;
import com.webull.openapi.core.http.HttpResponse;
import com.webull.openapi.core.http.RuntimeOptions;
import com.webull.openapi.core.http.okhttp.OkHttpClientPool;
import com.webull.openapi.core.http.okhttp.OkHttpRequestBuilder;
import com.webull.openapi.core.http.retry.DefaultHttpRetryCondition;
import com.webull.openapi.core.http.retry.HttpRetryContext;
import com.webull.openapi.core.http.retry.SynchronousHttpRetryable;
import com.webull.openapi.core.logger.Logger;
import com.webull.openapi.core.logger.LoggerFactory;
import com.webull.openapi.core.retry.RetriedFailedException;
import com.webull.openapi.core.retry.RetryPolicy;
import com.webull.openapi.core.retry.backoff.DefaultMixedBackoffStrategy;
import com.webull.openapi.core.serialize.JsonSerializer;
import com.webull.openapi.core.serialize.SerializeConfig;
import com.webull.openapi.core.utils.Assert;
import com.webull.openapi.core.utils.StringUtils;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.function.Supplier;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class HttpApiClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpApiClient.class);
    private final HttpApiConfig config;
    private final RetryPolicy retryPolicy;
    private final RuntimeOptions runtimeOptions;
    private String token;

    public HttpApiClient(HttpApiConfig config) {
        Assert.notNull("config", (Object)config);
        this.config = config;
        this.retryPolicy = this.config.getAutoRetry() ? new RetryPolicy(new DefaultHttpRetryCondition(this.config.getMaxRetries()), new DefaultMixedBackoffStrategy()) : RetryPolicy.never();
        this.runtimeOptions = config.getRuntimeOptions();
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public HttpApiConfig getConfig() {
        return this.config;
    }

    public Action request(HttpRequest httpRequest) {
        return new Action(httpRequest);
    }

    public class Action {
        private final HttpRequest request;
        private Type responseType;
        private SerializeConfig serializeConfig = SerializeConfig.httpDefault();

        private Action(HttpRequest request) {
            Assert.notNull("request", (Object)request);
            this.request = request;
        }

        public Action responseType(Type responseType) {
            Assert.notNull("responseType", (Object)responseType);
            this.responseType = responseType;
            return this;
        }

        public Action serializeWith(SerializeConfig serializeConfig) {
            Assert.notNull("serializeConfig", (Object)serializeConfig);
            this.serializeConfig = serializeConfig;
            return this;
        }

        public <T> T doAction() {
            Assert.notNull("responseType", (Object)this.responseType);
            try (HttpResponse response = this.doRequest(this.request);){
                if (response.getException() != null) {
                    throw response.getException();
                }
                String responseStr = response.getResponseBody();
                if (logger.isTraceEnabled()) {
                    logger.trace("HTTP request uri={}, response body={}", this.request.getUri(), responseStr);
                }
                Object t = JsonSerializer.fromJson(responseStr, this.responseType, this.serializeConfig);
                return t;
            }
        }

        public void doVoidAction() {
            try (HttpResponse response = this.doRequest(this.request);){
                if (response.getException() != null) {
                    throw response.getException();
                }
            }
        }

        private HttpResponse doRequest(HttpRequest request) {
            HttpRetryContext retryContext;
            Assert.notNull("request", (Object)request);
            request.setEndpointIfAbsent(HttpApiClient.this.config.getEndpoint());
            request.setPortIfAbsent(HttpApiClient.this.config.getPort());
            Supplier<HttpResponse> singleRequest = () -> this.doSingleRequest(request);
            try {
                HttpResponse response = singleRequest.get();
                if (response.isSuccess()) {
                    return response;
                }
                retryContext = new HttpRetryContext(request.getUri(), request.getMethod(), response.getStatusCode(), 1, response.getException());
            }
            catch (Exception ex) {
                retryContext = new HttpRetryContext(request.getUri(), request.getMethod(), 400, 1, ex);
            }
            SynchronousHttpRetryable retryable = new SynchronousHttpRetryable(singleRequest, HttpApiClient.this.retryPolicy);
            try {
                return (HttpResponse)retryable.retry(retryContext);
            }
            catch (RetriedFailedException ex) {
                logger.error("Http request error, Host:{}, SDK version:{}, Request:{}", request.getEndpoint(), ProjectReaderHelper.getClientSDKInfo(), JsonSerializer.toJson(request), ex);
                if (ex.getCause() instanceof ClientException) {
                    throw (ClientException)ex.getCause();
                }
                if (ex.getCause() instanceof ServerException) {
                    throw (ServerException)ex.getCause();
                }
                throw new ClientException("InvalidRequest", ex.getCause());
            }
        }

        private HttpResponse doSingleRequest(HttpRequest request) {
            String sign = DefaultSignatureComposer.getSign(request.getEndpoint(), HttpApiClient.this.config.getAppKey(), HttpApiClient.this.config.getAppSecret(), request);
            request.getHeaders().putIfAbsent("x-signature", sign);
            request.getHeaders().putIfAbsent("x-version", request.getVersion());
            if (StringUtils.isNotBlank(HttpApiClient.this.token)) {
                request.getHeaders().putIfAbsent("x-access-token", HttpApiClient.this.token);
            }
            try {
                URL url = new URL(request.getURL());
                RuntimeOptions options = request.getRuntimeOptions() != null ? request.getRuntimeOptions().parent(HttpApiClient.this.runtimeOptions) : HttpApiClient.this.runtimeOptions;
                OkHttpClient okHttpClient = OkHttpClientPool.get(url, options);
                Request okHttpRequest = OkHttpRequestBuilder.newRequest(request).url(url).header(request.getHeaders()).build();
                Response okHttpResponse = okHttpClient.newCall(okHttpRequest).execute();
                return new HttpResponse(okHttpResponse);
            }
            catch (Exception e) {
                logger.error("Http request error, Host:{}, SDK version:{}, Request:{}", request.getEndpoint(), ProjectReaderHelper.getClientSDKInfo(), JsonSerializer.toJson(request), e);
                throw new ClientException("InvalidRequest", e);
            }
        }
    }
}

