/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.api;

import com.google.gson.reflect.TypeToken;
import com.ycloud.client.ApiCallback;
import com.ycloud.client.ApiClient;
import com.ycloud.client.ApiException;
import com.ycloud.client.ApiResponse;
import com.ycloud.client.Configuration;
import com.ycloud.client.Pair;
import com.ycloud.client.model.WhatsappPhoneNumber;
import com.ycloud.client.model.WhatsappPhoneNumberPage;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class WhatsappPhoneNumbersApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WhatsappPhoneNumbersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WhatsappPhoneNumbersApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call listCall(Integer page, Integer limit, Boolean includeTotal, String filterWabaId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/whatsapp/phoneNumbers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (includeTotal != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeTotal", includeTotal));
        }
        if (filterWabaId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter.wabaId", filterWabaId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listValidateBeforeCall(Integer page, Integer limit, Boolean includeTotal, String filterWabaId, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCall(page, limit, includeTotal, filterWabaId, _callback);
        return localVarCall;
    }

    private ApiResponse<WhatsappPhoneNumberPage> listWithHttpInfo(Integer page, Integer limit, Boolean includeTotal, String filterWabaId) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(page, limit, includeTotal, filterWabaId, null);
        Type localVarReturnType = new TypeToken<WhatsappPhoneNumberPage>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listAsync(Integer page, Integer limit, Boolean includeTotal, String filterWabaId, ApiCallback<WhatsappPhoneNumberPage> _callback) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(page, limit, includeTotal, filterWabaId, _callback);
        Type localVarReturnType = new TypeToken<WhatsappPhoneNumberPage>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ApiListRequest list() {
        return new ApiListRequest();
    }

    public Call retrieveCall(String wabaId, String phoneNumber, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/whatsapp/phoneNumbers/{wabaId}/{phoneNumber}".replaceAll("\\{wabaId\\}", this.localVarApiClient.escapeString(wabaId.toString())).replaceAll("\\{phoneNumber\\}", this.localVarApiClient.escapeString(phoneNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call retrieveValidateBeforeCall(String wabaId, String phoneNumber, ApiCallback _callback) throws ApiException {
        if (wabaId == null) {
            throw new ApiException("Missing the required parameter 'wabaId' when calling retrieve(Async)");
        }
        if (phoneNumber == null) {
            throw new ApiException("Missing the required parameter 'phoneNumber' when calling retrieve(Async)");
        }
        Call localVarCall = this.retrieveCall(wabaId, phoneNumber, _callback);
        return localVarCall;
    }

    public WhatsappPhoneNumber retrieve(String wabaId, String phoneNumber) throws ApiException {
        ApiResponse<WhatsappPhoneNumber> localVarResp = this.retrieveWithHttpInfo(wabaId, phoneNumber);
        return localVarResp.getData();
    }

    public ApiResponse<WhatsappPhoneNumber> retrieveWithHttpInfo(String wabaId, String phoneNumber) throws ApiException {
        Call localVarCall = this.retrieveValidateBeforeCall(wabaId, phoneNumber, null);
        Type localVarReturnType = new TypeToken<WhatsappPhoneNumber>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call retrieveAsync(String wabaId, String phoneNumber, ApiCallback<WhatsappPhoneNumber> _callback) throws ApiException {
        Call localVarCall = this.retrieveValidateBeforeCall(wabaId, phoneNumber, _callback);
        Type localVarReturnType = new TypeToken<WhatsappPhoneNumber>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class ApiListRequest {
        private Integer page;
        private Integer limit;
        private Boolean includeTotal;
        private String filterWabaId;

        private ApiListRequest() {
        }

        public ApiListRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public ApiListRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ApiListRequest includeTotal(Boolean includeTotal) {
            this.includeTotal = includeTotal;
            return this;
        }

        public ApiListRequest filterWabaId(String filterWabaId) {
            this.filterWabaId = filterWabaId;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WhatsappPhoneNumbersApi.this.listCall(this.page, this.limit, this.includeTotal, this.filterWabaId, _callback);
        }

        public WhatsappPhoneNumberPage execute() throws ApiException {
            ApiResponse localVarResp = WhatsappPhoneNumbersApi.this.listWithHttpInfo(this.page, this.limit, this.includeTotal, this.filterWabaId);
            return (WhatsappPhoneNumberPage)localVarResp.getData();
        }

        public ApiResponse<WhatsappPhoneNumberPage> executeWithHttpInfo() throws ApiException {
            return WhatsappPhoneNumbersApi.this.listWithHttpInfo(this.page, this.limit, this.includeTotal, this.filterWabaId);
        }

        public Call executeAsync(ApiCallback<WhatsappPhoneNumberPage> _callback) throws ApiException {
            return WhatsappPhoneNumbersApi.this.listAsync(this.page, this.limit, this.includeTotal, this.filterWabaId, _callback);
        }
    }
}

