/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import com.ycloud.client.model.WebhookEndpointStatus;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WebhookEndpoint {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static final String SERIALIZED_NAME_ENABLED_EVENTS = "enabledEvents";
    @SerializedName(value="enabledEvents")
    private List<String> enabledEvents = null;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private WebhookEndpointStatus status;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_CREATE_TIME = "createTime";
    @SerializedName(value="createTime")
    private Date createTime;
    public static final String SERIALIZED_NAME_UPDATE_TIME = "updateTime";
    @SerializedName(value="updateTime")
    private Date updateTime;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WebhookEndpoint id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="wh627c8640675de8fc689ab9d9", required=true, value="Unique ID for the object.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WebhookEndpoint url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://httpbin.org/anything?tag=api", value="The URL of the webhook endpoint.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public WebhookEndpoint enabledEvents(List<String> enabledEvents) {
        this.enabledEvents = enabledEvents;
        return this;
    }

    public WebhookEndpoint addEnabledEventsItem(String enabledEventsItem) {
        if (this.enabledEvents == null) {
            this.enabledEvents = new ArrayList<String>();
        }
        this.enabledEvents.add(enabledEventsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"email.delivery.updated\",\"sms.message.updated\",\"voice.message.updated\"]", value="The list of events to enable for this endpoint.")
    public List<String> getEnabledEvents() {
        return this.enabledEvents;
    }

    public void setEnabledEvents(List<String> enabledEvents) {
        this.enabledEvents = enabledEvents;
    }

    public WebhookEndpoint description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="My first webhook endpoint.", value="An optional description of what the webhook is used for.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WebhookEndpoint status(WebhookEndpointStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WebhookEndpointStatus getStatus() {
        return this.status;
    }

    public void setStatus(WebhookEndpointStatus status) {
        this.status = status;
    }

    public WebhookEndpoint secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="whsec_abc4147651944f02baf3be1eb45d33f1", value="The endpoint's secret, used to generate webhook signatures.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public WebhookEndpoint createTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2022-06-01T12:00Z", value="The time at which this object was created, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., `2022-06-01T12:00:00.000Z`.")
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public WebhookEndpoint updateTime(Date updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2022-06-01T12:00Z", value="The time at which this object was updated, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., `2022-06-01T12:00:00.000Z`.")
    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public WebhookEndpoint putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookEndpoint webhookEndpoint = (WebhookEndpoint)o;
        return Objects.equals(this.id, webhookEndpoint.id) && Objects.equals(this.url, webhookEndpoint.url) && Objects.equals(this.enabledEvents, webhookEndpoint.enabledEvents) && Objects.equals(this.description, webhookEndpoint.description) && Objects.equals((Object)this.status, (Object)webhookEndpoint.status) && Objects.equals(this.secret, webhookEndpoint.secret) && Objects.equals(this.createTime, webhookEndpoint.createTime) && Objects.equals(this.updateTime, webhookEndpoint.updateTime) && Objects.equals(this.additionalProperties, webhookEndpoint.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.url, this.enabledEvents, this.description, this.status, this.secret, this.createTime, this.updateTime, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhookEndpoint {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    enabledEvents: ").append(this.toIndentedString(this.enabledEvents)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    createTime: ").append(this.toIndentedString(this.createTime)).append("\n");
        sb.append("    updateTime: ").append(this.toIndentedString(this.updateTime)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WebhookEndpoint is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URL) != null && !jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENABLED_EVENTS) != null && !jsonObj.get(SERIALIZED_NAME_ENABLED_EVENTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `enabledEvents` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENABLED_EVENTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECRET) != null && !jsonObj.get(SERIALIZED_NAME_SECRET).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `secret` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECRET).toString()));
        }
    }

    public static WebhookEndpoint fromJson(String jsonString) throws IOException {
        return (WebhookEndpoint)JSON.getGson().fromJson(jsonString, WebhookEndpoint.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiFields.add(SERIALIZED_NAME_ENABLED_EVENTS);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_SECRET);
        openapiFields.add(SERIALIZED_NAME_CREATE_TIME);
        openapiFields.add(SERIALIZED_NAME_UPDATE_TIME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WebhookEndpoint.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WebhookEndpoint.class));
            return new TypeAdapter<WebhookEndpoint>(){

                public void write(JsonWriter out, WebhookEndpoint value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WebhookEndpoint read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WebhookEndpoint.validateJsonObject(jsonObj);
                    WebhookEndpoint instance = (WebhookEndpoint)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

