/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import com.ycloud.client.model.WhatsappInboundMessageButton;
import com.ycloud.client.model.WhatsappInboundMessageInteractive;
import com.ycloud.client.model.WhatsappInboundMessageLocation;
import com.ycloud.client.model.WhatsappInboundMessageMedia;
import com.ycloud.client.model.WhatsappInboundMessageText;
import com.ycloud.client.model.WhatsappInboundMessageType;
import com.ycloud.client.model.WhatsappMessageContact;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="WhatsApp inbound message object.")
public class WhatsappInboundMessage {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_WABA_ID = "wabaId";
    @SerializedName(value="wabaId")
    private String wabaId;
    public static final String SERIALIZED_NAME_FROM = "from";
    @SerializedName(value="from")
    private String from;
    public static final String SERIALIZED_NAME_TO = "to";
    @SerializedName(value="to")
    private String to;
    public static final String SERIALIZED_NAME_SEND_TIME = "sendTime";
    @SerializedName(value="sendTime")
    private Date sendTime;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private WhatsappInboundMessageType type;
    public static final String SERIALIZED_NAME_TEXT = "text";
    @SerializedName(value="text")
    private WhatsappInboundMessageText text;
    public static final String SERIALIZED_NAME_IMAGE = "image";
    @SerializedName(value="image")
    private WhatsappInboundMessageMedia image;
    public static final String SERIALIZED_NAME_VIDEO = "video";
    @SerializedName(value="video")
    private WhatsappInboundMessageMedia video;
    public static final String SERIALIZED_NAME_AUDIO = "audio";
    @SerializedName(value="audio")
    private WhatsappInboundMessageMedia audio;
    public static final String SERIALIZED_NAME_DOCUMENT = "document";
    @SerializedName(value="document")
    private WhatsappInboundMessageMedia document;
    public static final String SERIALIZED_NAME_STICKER = "sticker";
    @SerializedName(value="sticker")
    private WhatsappInboundMessageMedia sticker;
    public static final String SERIALIZED_NAME_INTERACTIVE = "interactive";
    @SerializedName(value="interactive")
    private WhatsappInboundMessageInteractive interactive;
    public static final String SERIALIZED_NAME_LOCATION = "location";
    @SerializedName(value="location")
    private WhatsappInboundMessageLocation location;
    public static final String SERIALIZED_NAME_BUTTON = "button";
    @SerializedName(value="button")
    private WhatsappInboundMessageButton button;
    public static final String SERIALIZED_NAME_CONTACTS = "contacts";
    @SerializedName(value="contacts")
    private List<WhatsappMessageContact> contacts = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WhatsappInboundMessage id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Unique ID for the object.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WhatsappInboundMessage wabaId(String wabaId) {
        this.wabaId = wabaId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="whatsapp-business-account-id", value="WhatsApp Business Account ID.")
    public String getWabaId() {
        return this.wabaId;
    }

    public void setWabaId(String wabaId) {
        this.wabaId = wabaId;
    }

    public WhatsappInboundMessage from(String from) {
        this.from = from;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="+447901614024", value="The sender's phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format.")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public WhatsappInboundMessage to(String to) {
        this.to = to;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="+447901614024", value="The recipient's phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format.")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public WhatsappInboundMessage sendTime(Date sendTime) {
        this.sendTime = sendTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2022-06-01T12:00Z", value="The time at which this message is sent, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., `2022-06-01T12:00:00.000Z`.")
    public Date getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public WhatsappInboundMessage type(WhatsappInboundMessageType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappInboundMessageType getType() {
        return this.type;
    }

    public void setType(WhatsappInboundMessageType type) {
        this.type = type;
    }

    public WhatsappInboundMessage text(WhatsappInboundMessageText text) {
        this.text = text;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappInboundMessageText getText() {
        return this.text;
    }

    public void setText(WhatsappInboundMessageText text) {
        this.text = text;
    }

    public WhatsappInboundMessage image(WhatsappInboundMessageMedia image) {
        this.image = image;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappInboundMessageMedia getImage() {
        return this.image;
    }

    public void setImage(WhatsappInboundMessageMedia image) {
        this.image = image;
    }

    public WhatsappInboundMessage video(WhatsappInboundMessageMedia video) {
        this.video = video;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappInboundMessageMedia getVideo() {
        return this.video;
    }

    public void setVideo(WhatsappInboundMessageMedia video) {
        this.video = video;
    }

    public WhatsappInboundMessage audio(WhatsappInboundMessageMedia audio) {
        this.audio = audio;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappInboundMessageMedia getAudio() {
        return this.audio;
    }

    public void setAudio(WhatsappInboundMessageMedia audio) {
        this.audio = audio;
    }

    public WhatsappInboundMessage document(WhatsappInboundMessageMedia document) {
        this.document = document;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappInboundMessageMedia getDocument() {
        return this.document;
    }

    public void setDocument(WhatsappInboundMessageMedia document) {
        this.document = document;
    }

    public WhatsappInboundMessage sticker(WhatsappInboundMessageMedia sticker) {
        this.sticker = sticker;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappInboundMessageMedia getSticker() {
        return this.sticker;
    }

    public void setSticker(WhatsappInboundMessageMedia sticker) {
        this.sticker = sticker;
    }

    public WhatsappInboundMessage interactive(WhatsappInboundMessageInteractive interactive) {
        this.interactive = interactive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappInboundMessageInteractive getInteractive() {
        return this.interactive;
    }

    public void setInteractive(WhatsappInboundMessageInteractive interactive) {
        this.interactive = interactive;
    }

    public WhatsappInboundMessage location(WhatsappInboundMessageLocation location) {
        this.location = location;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappInboundMessageLocation getLocation() {
        return this.location;
    }

    public void setLocation(WhatsappInboundMessageLocation location) {
        this.location = location;
    }

    public WhatsappInboundMessage button(WhatsappInboundMessageButton button) {
        this.button = button;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappInboundMessageButton getButton() {
        return this.button;
    }

    public void setButton(WhatsappInboundMessageButton button) {
        this.button = button;
    }

    public WhatsappInboundMessage contacts(List<WhatsappMessageContact> contacts) {
        this.contacts = contacts;
        return this;
    }

    public WhatsappInboundMessage addContactsItem(WhatsappMessageContact contactsItem) {
        if (this.contacts == null) {
            this.contacts = new ArrayList<WhatsappMessageContact>();
        }
        this.contacts.add(contactsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<WhatsappMessageContact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<WhatsappMessageContact> contacts) {
        this.contacts = contacts;
    }

    public WhatsappInboundMessage putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsappInboundMessage whatsappInboundMessage = (WhatsappInboundMessage)o;
        return Objects.equals(this.id, whatsappInboundMessage.id) && Objects.equals(this.wabaId, whatsappInboundMessage.wabaId) && Objects.equals(this.from, whatsappInboundMessage.from) && Objects.equals(this.to, whatsappInboundMessage.to) && Objects.equals(this.sendTime, whatsappInboundMessage.sendTime) && Objects.equals((Object)this.type, (Object)whatsappInboundMessage.type) && Objects.equals(this.text, whatsappInboundMessage.text) && Objects.equals(this.image, whatsappInboundMessage.image) && Objects.equals(this.video, whatsappInboundMessage.video) && Objects.equals(this.audio, whatsappInboundMessage.audio) && Objects.equals(this.document, whatsappInboundMessage.document) && Objects.equals(this.sticker, whatsappInboundMessage.sticker) && Objects.equals(this.interactive, whatsappInboundMessage.interactive) && Objects.equals(this.location, whatsappInboundMessage.location) && Objects.equals(this.button, whatsappInboundMessage.button) && Objects.equals(this.contacts, whatsappInboundMessage.contacts) && Objects.equals(this.additionalProperties, whatsappInboundMessage.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.wabaId, this.from, this.to, this.sendTime, this.type, this.text, this.image, this.video, this.audio, this.document, this.sticker, this.interactive, this.location, this.button, this.contacts, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsappInboundMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    wabaId: ").append(this.toIndentedString(this.wabaId)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    sendTime: ").append(this.toIndentedString(this.sendTime)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    video: ").append(this.toIndentedString(this.video)).append("\n");
        sb.append("    audio: ").append(this.toIndentedString(this.audio)).append("\n");
        sb.append("    document: ").append(this.toIndentedString(this.document)).append("\n");
        sb.append("    sticker: ").append(this.toIndentedString(this.sticker)).append("\n");
        sb.append("    interactive: ").append(this.toIndentedString(this.interactive)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    button: ").append(this.toIndentedString(this.button)).append("\n");
        sb.append("    contacts: ").append(this.toIndentedString(this.contacts)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraycontacts;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappInboundMessage is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WABA_ID) != null && !jsonObj.get(SERIALIZED_NAME_WABA_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `wabaId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WABA_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FROM) != null && !jsonObj.get(SERIALIZED_NAME_FROM).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `from` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FROM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TO) != null && !jsonObj.get(SERIALIZED_NAME_TO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `to` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TO).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TEXT) != null) {
            WhatsappInboundMessageText.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TEXT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_IMAGE) != null) {
            WhatsappInboundMessageMedia.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_IMAGE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_VIDEO) != null) {
            WhatsappInboundMessageMedia.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_VIDEO));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AUDIO) != null) {
            WhatsappInboundMessageMedia.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AUDIO));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DOCUMENT) != null) {
            WhatsappInboundMessageMedia.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DOCUMENT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_STICKER) != null) {
            WhatsappInboundMessageMedia.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_STICKER));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_INTERACTIVE) != null) {
            WhatsappInboundMessageInteractive.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_INTERACTIVE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LOCATION) != null) {
            WhatsappInboundMessageLocation.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LOCATION));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BUTTON) != null) {
            WhatsappInboundMessageButton.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BUTTON));
        }
        if ((jsonArraycontacts = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONTACTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONTACTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `contacts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTACTS).toString()));
            }
            for (int i = 0; i < jsonArraycontacts.size(); ++i) {
                WhatsappMessageContact.validateJsonObject(jsonArraycontacts.get(i).getAsJsonObject());
            }
        }
    }

    public static WhatsappInboundMessage fromJson(String jsonString) throws IOException {
        return (WhatsappInboundMessage)JSON.getGson().fromJson(jsonString, WhatsappInboundMessage.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_WABA_ID);
        openapiFields.add(SERIALIZED_NAME_FROM);
        openapiFields.add(SERIALIZED_NAME_TO);
        openapiFields.add(SERIALIZED_NAME_SEND_TIME);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_TEXT);
        openapiFields.add(SERIALIZED_NAME_IMAGE);
        openapiFields.add(SERIALIZED_NAME_VIDEO);
        openapiFields.add(SERIALIZED_NAME_AUDIO);
        openapiFields.add(SERIALIZED_NAME_DOCUMENT);
        openapiFields.add(SERIALIZED_NAME_STICKER);
        openapiFields.add(SERIALIZED_NAME_INTERACTIVE);
        openapiFields.add(SERIALIZED_NAME_LOCATION);
        openapiFields.add(SERIALIZED_NAME_BUTTON);
        openapiFields.add(SERIALIZED_NAME_CONTACTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WhatsappInboundMessage.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WhatsappInboundMessage.class));
            return new TypeAdapter<WhatsappInboundMessage>(){

                public void write(JsonWriter out, WhatsappInboundMessage value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WhatsappInboundMessage read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WhatsappInboundMessage.validateJsonObject(jsonObj);
                    WhatsappInboundMessage instance = (WhatsappInboundMessage)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

