/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import com.ycloud.client.model.WhatsappMessageContact;
import com.ycloud.client.model.WhatsappMessageInteractive;
import com.ycloud.client.model.WhatsappMessageLocation;
import com.ycloud.client.model.WhatsappMessageMedia;
import com.ycloud.client.model.WhatsappMessageStatus;
import com.ycloud.client.model.WhatsappMessageTemplate;
import com.ycloud.client.model.WhatsappMessageText;
import com.ycloud.client.model.WhatsappMessageType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="WhatsApp outbound message object.")
public class WhatsappMessage {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_WABA_ID = "wabaId";
    @SerializedName(value="wabaId")
    private String wabaId;
    public static final String SERIALIZED_NAME_FROM = "from";
    @SerializedName(value="from")
    private String from;
    public static final String SERIALIZED_NAME_TO = "to";
    @SerializedName(value="to")
    private String to;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private WhatsappMessageType type;
    public static final String SERIALIZED_NAME_TEMPLATE = "template";
    @SerializedName(value="template")
    private WhatsappMessageTemplate template;
    public static final String SERIALIZED_NAME_TEXT = "text";
    @SerializedName(value="text")
    private WhatsappMessageText text;
    public static final String SERIALIZED_NAME_IMAGE = "image";
    @SerializedName(value="image")
    private WhatsappMessageMedia image;
    public static final String SERIALIZED_NAME_VIDEO = "video";
    @SerializedName(value="video")
    private WhatsappMessageMedia video;
    public static final String SERIALIZED_NAME_AUDIO = "audio";
    @SerializedName(value="audio")
    private WhatsappMessageMedia audio;
    public static final String SERIALIZED_NAME_DOCUMENT = "document";
    @SerializedName(value="document")
    private WhatsappMessageMedia document;
    public static final String SERIALIZED_NAME_LOCATION = "location";
    @SerializedName(value="location")
    private WhatsappMessageLocation location;
    public static final String SERIALIZED_NAME_INTERACTIVE = "interactive";
    @SerializedName(value="interactive")
    private WhatsappMessageInteractive interactive;
    public static final String SERIALIZED_NAME_CONTACTS = "contacts";
    @SerializedName(value="contacts")
    private List<WhatsappMessageContact> contacts = null;
    public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
    @SerializedName(value="externalId")
    private String externalId;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private WhatsappMessageStatus status;
    public static final String SERIALIZED_NAME_ERROR_CODE = "errorCode";
    @SerializedName(value="errorCode")
    private String errorCode;
    public static final String SERIALIZED_NAME_ERROR_MESSAGE = "errorMessage";
    @SerializedName(value="errorMessage")
    private String errorMessage;
    public static final String SERIALIZED_NAME_CREATE_TIME = "createTime";
    @SerializedName(value="createTime")
    private Date createTime;
    public static final String SERIALIZED_NAME_UPDATE_TIME = "updateTime";
    @SerializedName(value="updateTime")
    private Date updateTime;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WhatsappMessage id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Unique ID for the object.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WhatsappMessage wabaId(String wabaId) {
        this.wabaId = wabaId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="whatsapp-business-account-id", value="WhatsApp Business Account ID.")
    public String getWabaId() {
        return this.wabaId;
    }

    public void setWabaId(String wabaId) {
        this.wabaId = wabaId;
    }

    public WhatsappMessage from(String from) {
        this.from = from;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="+447901614024", required=true, value="The sender's phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format.")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public WhatsappMessage to(String to) {
        this.to = to;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="+447901614024", required=true, value="The recipient's phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format.")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public WhatsappMessage type(WhatsappMessageType type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public WhatsappMessageType getType() {
        return this.type;
    }

    public void setType(WhatsappMessageType type) {
        this.type = type;
    }

    public WhatsappMessage template(WhatsappMessageTemplate template) {
        this.template = template;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessageTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(WhatsappMessageTemplate template) {
        this.template = template;
    }

    public WhatsappMessage text(WhatsappMessageText text) {
        this.text = text;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessageText getText() {
        return this.text;
    }

    public void setText(WhatsappMessageText text) {
        this.text = text;
    }

    public WhatsappMessage image(WhatsappMessageMedia image) {
        this.image = image;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessageMedia getImage() {
        return this.image;
    }

    public void setImage(WhatsappMessageMedia image) {
        this.image = image;
    }

    public WhatsappMessage video(WhatsappMessageMedia video) {
        this.video = video;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessageMedia getVideo() {
        return this.video;
    }

    public void setVideo(WhatsappMessageMedia video) {
        this.video = video;
    }

    public WhatsappMessage audio(WhatsappMessageMedia audio) {
        this.audio = audio;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessageMedia getAudio() {
        return this.audio;
    }

    public void setAudio(WhatsappMessageMedia audio) {
        this.audio = audio;
    }

    public WhatsappMessage document(WhatsappMessageMedia document) {
        this.document = document;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessageMedia getDocument() {
        return this.document;
    }

    public void setDocument(WhatsappMessageMedia document) {
        this.document = document;
    }

    public WhatsappMessage location(WhatsappMessageLocation location) {
        this.location = location;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessageLocation getLocation() {
        return this.location;
    }

    public void setLocation(WhatsappMessageLocation location) {
        this.location = location;
    }

    public WhatsappMessage interactive(WhatsappMessageInteractive interactive) {
        this.interactive = interactive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessageInteractive getInteractive() {
        return this.interactive;
    }

    public void setInteractive(WhatsappMessageInteractive interactive) {
        this.interactive = interactive;
    }

    public WhatsappMessage contacts(List<WhatsappMessageContact> contacts) {
        this.contacts = contacts;
        return this;
    }

    public WhatsappMessage addContactsItem(WhatsappMessageContact contactsItem) {
        if (this.contacts == null) {
            this.contacts = new ArrayList<WhatsappMessageContact>();
        }
        this.contacts.add(contactsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<WhatsappMessageContact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<WhatsappMessageContact> contacts) {
        this.contacts = contacts;
    }

    public WhatsappMessage externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique string to reference the object. This can be an order number or similar, and can be used to reconcile the object with your internal systems.")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public WhatsappMessage status(WhatsappMessageStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessageStatus getStatus() {
        return this.status;
    }

    public void setStatus(WhatsappMessageStatus status) {
        this.status = status;
    }

    public WhatsappMessage errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Error code when the message status is `failed`.")
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public WhatsappMessage errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Error message when the message status is `failed`.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public WhatsappMessage createTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2022-06-01T12:00Z", value="The time at which this message is created, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., `2022-06-01T12:00:00.000Z`.")
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public WhatsappMessage updateTime(Date updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2022-06-01T12:00Z", value="The time at which this message is updated, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., `2022-06-01T12:00:00.000Z`.")
    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public WhatsappMessage putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsappMessage whatsappMessage = (WhatsappMessage)o;
        return Objects.equals(this.id, whatsappMessage.id) && Objects.equals(this.wabaId, whatsappMessage.wabaId) && Objects.equals(this.from, whatsappMessage.from) && Objects.equals(this.to, whatsappMessage.to) && Objects.equals((Object)this.type, (Object)whatsappMessage.type) && Objects.equals(this.template, whatsappMessage.template) && Objects.equals(this.text, whatsappMessage.text) && Objects.equals(this.image, whatsappMessage.image) && Objects.equals(this.video, whatsappMessage.video) && Objects.equals(this.audio, whatsappMessage.audio) && Objects.equals(this.document, whatsappMessage.document) && Objects.equals(this.location, whatsappMessage.location) && Objects.equals(this.interactive, whatsappMessage.interactive) && Objects.equals(this.contacts, whatsappMessage.contacts) && Objects.equals(this.externalId, whatsappMessage.externalId) && Objects.equals((Object)this.status, (Object)whatsappMessage.status) && Objects.equals(this.errorCode, whatsappMessage.errorCode) && Objects.equals(this.errorMessage, whatsappMessage.errorMessage) && Objects.equals(this.createTime, whatsappMessage.createTime) && Objects.equals(this.updateTime, whatsappMessage.updateTime) && Objects.equals(this.additionalProperties, whatsappMessage.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.wabaId, this.from, this.to, this.type, this.template, this.text, this.image, this.video, this.audio, this.document, this.location, this.interactive, this.contacts, this.externalId, this.status, this.errorCode, this.errorMessage, this.createTime, this.updateTime, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsappMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    wabaId: ").append(this.toIndentedString(this.wabaId)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    video: ").append(this.toIndentedString(this.video)).append("\n");
        sb.append("    audio: ").append(this.toIndentedString(this.audio)).append("\n");
        sb.append("    document: ").append(this.toIndentedString(this.document)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    interactive: ").append(this.toIndentedString(this.interactive)).append("\n");
        sb.append("    contacts: ").append(this.toIndentedString(this.contacts)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    createTime: ").append(this.toIndentedString(this.createTime)).append("\n");
        sb.append("    updateTime: ").append(this.toIndentedString(this.updateTime)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraycontacts;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappMessage is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WABA_ID) != null && !jsonObj.get(SERIALIZED_NAME_WABA_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `wabaId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WABA_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FROM) != null && !jsonObj.get(SERIALIZED_NAME_FROM).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `from` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FROM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TO) != null && !jsonObj.get(SERIALIZED_NAME_TO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `to` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TO).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TEMPLATE) != null) {
            WhatsappMessageTemplate.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TEMPLATE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TEXT) != null) {
            WhatsappMessageText.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TEXT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_IMAGE) != null) {
            WhatsappMessageMedia.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_IMAGE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_VIDEO) != null) {
            WhatsappMessageMedia.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_VIDEO));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AUDIO) != null) {
            WhatsappMessageMedia.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AUDIO));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DOCUMENT) != null) {
            WhatsappMessageMedia.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DOCUMENT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LOCATION) != null) {
            WhatsappMessageLocation.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LOCATION));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_INTERACTIVE) != null) {
            WhatsappMessageInteractive.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_INTERACTIVE));
        }
        if ((jsonArraycontacts = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONTACTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONTACTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `contacts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTACTS).toString()));
            }
            for (int i = 0; i < jsonArraycontacts.size(); ++i) {
                WhatsappMessageContact.validateJsonObject(jsonArraycontacts.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_EXTERNAL_ID) != null && !jsonObj.get(SERIALIZED_NAME_EXTERNAL_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `externalId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXTERNAL_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ERROR_CODE) != null && !jsonObj.get(SERIALIZED_NAME_ERROR_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `errorCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ERROR_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ERROR_MESSAGE) != null && !jsonObj.get(SERIALIZED_NAME_ERROR_MESSAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `errorMessage` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ERROR_MESSAGE).toString()));
        }
    }

    public static WhatsappMessage fromJson(String jsonString) throws IOException {
        return (WhatsappMessage)JSON.getGson().fromJson(jsonString, WhatsappMessage.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_WABA_ID);
        openapiFields.add(SERIALIZED_NAME_FROM);
        openapiFields.add(SERIALIZED_NAME_TO);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_TEMPLATE);
        openapiFields.add(SERIALIZED_NAME_TEXT);
        openapiFields.add(SERIALIZED_NAME_IMAGE);
        openapiFields.add(SERIALIZED_NAME_VIDEO);
        openapiFields.add(SERIALIZED_NAME_AUDIO);
        openapiFields.add(SERIALIZED_NAME_DOCUMENT);
        openapiFields.add(SERIALIZED_NAME_LOCATION);
        openapiFields.add(SERIALIZED_NAME_INTERACTIVE);
        openapiFields.add(SERIALIZED_NAME_CONTACTS);
        openapiFields.add(SERIALIZED_NAME_EXTERNAL_ID);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_ERROR_CODE);
        openapiFields.add(SERIALIZED_NAME_ERROR_MESSAGE);
        openapiFields.add(SERIALIZED_NAME_CREATE_TIME);
        openapiFields.add(SERIALIZED_NAME_UPDATE_TIME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_FROM);
        openapiRequiredFields.add(SERIALIZED_NAME_TO);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WhatsappMessage.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WhatsappMessage.class));
            return new TypeAdapter<WhatsappMessage>(){

                public void write(JsonWriter out, WhatsappMessage value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WhatsappMessage read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WhatsappMessage.validateJsonObject(jsonObj);
                    WhatsappMessage instance = (WhatsappMessage)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

